/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.elasticsearch.injection.guice.ConfigurationException;
import org.elasticsearch.injection.guice.ConstructionProxy;
import org.elasticsearch.injection.guice.ConstructorInjector;
import org.elasticsearch.injection.guice.InjectorImpl;
import org.elasticsearch.injection.guice.MembersInjectorImpl;
import org.elasticsearch.injection.guice.SingleParameterInjector;
import org.elasticsearch.injection.guice.TypeLiteral;
import org.elasticsearch.injection.guice.internal.Errors;
import org.elasticsearch.injection.guice.internal.ErrorsException;
import org.elasticsearch.injection.guice.internal.FailableCache;
import org.elasticsearch.injection.guice.spi.InjectionPoint;

class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<TypeLiteral<?>, ConstructorInjector<?>> cache = new FailableCache<TypeLiteral<?>, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(TypeLiteral<?> type, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(type, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public <T> ConstructorInjector<T> get(TypeLiteral<T> key, Errors errors) throws ErrorsException {
        return this.cache.get(key, errors);
    }

    private <T> ConstructorInjector<T> createConstructor(TypeLiteral<T> type, Errors errors) throws ErrorsException {
        InjectionPoint injectionPoint;
        int numErrorsBefore = errors.size();
        try {
            injectionPoint = InjectionPoint.forConstructorOf(type);
        }
        catch (ConfigurationException e) {
            errors.merge(e.getErrorMessages());
            throw errors.toException();
        }
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<T> membersInjector = this.injector.membersInjectorStore.get(type, errors);
        errors.throwIfNewErrors(numErrorsBefore);
        final Constructor constructor = (Constructor)injectionPoint.getMember();
        return new ConstructorInjector<T>(new ConstructionProxy<T>(){

            @Override
            public T newInstance(Object ... arguments) throws InvocationTargetException {
                try {
                    return constructor.newInstance(arguments);
                }
                catch (InstantiationException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError("Wrong access modifiers on " + String.valueOf(constructor), e);
                }
            }

            @Override
            public InjectionPoint getInjectionPoint() {
                return injectionPoint;
            }
        }, constructorParameterInjectors, membersInjector);
    }
}

