/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.NoSuchNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.CancellableFanOut;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public abstract class TransportTasksAction<OperationTask extends Task, TasksRequest extends BaseTasksRequest<TasksRequest>, TasksResponse extends BaseTasksResponse, TaskResponse extends Writeable>
extends HandledTransportAction<TasksRequest, TasksResponse> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final Writeable.Reader<TasksRequest> requestReader;
    protected final Writeable.Reader<TaskResponse> responseReader;
    protected final String transportNodeAction;
    private final Writeable.Reader<NodeTasksResponse> nodeResponseReader = x$0 -> new NodeTasksResponse(x$0);

    protected TransportTasksAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<TasksRequest> requestReader, Writeable.Reader<TaskResponse> responseReader, Executor nodeExecutor) {
        super(actionName, transportService, actionFilters, requestReader, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportNodeAction = actionName + "[n]";
        this.requestReader = requestReader;
        this.responseReader = responseReader;
        transportService.registerRequestHandler(this.transportNodeAction, nodeExecutor, x$0 -> new NodeTaskRequest(x$0), new NodeTransportHandler());
    }

    @Override
    protected void doExecute(Task task, TasksRequest request, ActionListener<TasksResponse> listener) {
        DiscoveryNodes discoveryNodes = this.clusterService.state().nodes();
        String[] nodeIds = this.resolveNodes(request, discoveryNodes);
        new CancellableFanOut<String, NodeTasksResponse, TasksResponse>((BaseTasksRequest)request, discoveryNodes, task){
            final ArrayList<TaskResponse> taskResponses = new ArrayList();
            final ArrayList<TaskOperationFailure> taskOperationFailures = new ArrayList();
            final ArrayList<FailedNodeException> failedNodeExceptions = new ArrayList();
            final TransportRequestOptions transportRequestOptions = TransportRequestOptions.timeout(this.val$request.getTimeout());
            final /* synthetic */ BaseTasksRequest val$request;
            final /* synthetic */ DiscoveryNodes val$discoveryNodes;
            final /* synthetic */ Task val$task;
            {
                this.val$request = baseTasksRequest;
                this.val$discoveryNodes = discoveryNodes;
                this.val$task = task;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void sendItemRequest(String nodeId, ActionListener<NodeTasksResponse> listener) {
                DiscoveryNode discoveryNode = this.val$discoveryNodes.get(nodeId);
                if (discoveryNode == null) {
                    listener.onFailure(new NoSuchNodeException(nodeId));
                    return;
                }
                NodeTaskRequest nodeTaskRequest = new NodeTaskRequest(TransportTasksAction.this, this.val$request);
                try {
                    TransportTasksAction.this.transportService.sendChildRequest(discoveryNode, TransportTasksAction.this.transportNodeAction, (TransportRequest)nodeTaskRequest, this.val$task, this.transportRequestOptions, new ActionListenerResponseHandler<NodeTasksResponse>(listener, TransportTasksAction.this.nodeResponseReader, TransportResponseHandler.TRANSPORT_WORKER));
                }
                finally {
                    nodeTaskRequest.decRef();
                }
            }

            @Override
            protected void onItemResponse(String nodeId, NodeTasksResponse nodeTasksResponse) {
                1.addAllSynchronized(this.taskResponses, nodeTasksResponse.results);
                1.addAllSynchronized(this.taskOperationFailures, nodeTasksResponse.exceptions);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static <T> void addAllSynchronized(List<T> allResults, Collection<T> response) {
                if (!response.isEmpty()) {
                    List<T> list = allResults;
                    synchronized (list) {
                        allResults.addAll(response);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onItemFailure(String nodeId, Exception e) {
                TransportTasksAction.this.logger.debug(() -> Strings.format("failed to execute on node [%s]", nodeId), (Throwable)e);
                ArrayList<FailedNodeException> arrayList = this.failedNodeExceptions;
                synchronized (arrayList) {
                    this.failedNodeExceptions.add(new FailedNodeException(nodeId, "Failed node [" + nodeId + "]", e));
                }
            }

            @Override
            protected TasksResponse onCompletion() {
                return TransportTasksAction.this.newResponse(this.val$request, this.taskResponses, this.taskOperationFailures, this.failedNodeExceptions);
            }

            public String toString() {
                return TransportTasksAction.this.actionName;
            }
        }.run(task, Iterators.forArray(nodeIds), listener);
    }

    private void nodeOperation(final CancellableTask nodeTask, ActionListener<NodeTasksResponse> listener, TasksRequest request, final List<OperationTask> operationTasks) {
        new CancellableFanOut<OperationTask, TaskResponse, NodeTasksResponse>((BaseTasksRequest)request){
            final ArrayList<TaskResponse> results;
            final ArrayList<TaskOperationFailure> exceptions;
            final /* synthetic */ BaseTasksRequest val$request;
            {
                this.val$request = baseTasksRequest;
                this.results = new ArrayList(operationTasks.size());
                this.exceptions = new ArrayList();
            }

            @Override
            protected void sendItemRequest(OperationTask operationTask, ActionListener<TaskResponse> listener) {
                ActionListener.run(listener, l -> TransportTasksAction.this.taskOperation(nodeTask, this.val$request, operationTask, l));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onItemResponse(OperationTask operationTask, TaskResponse taskResponse) {
                ArrayList arrayList = this.results;
                synchronized (arrayList) {
                    this.results.add(taskResponse);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onItemFailure(OperationTask operationTask, Exception e) {
                ArrayList<TaskOperationFailure> arrayList = this.exceptions;
                synchronized (arrayList) {
                    this.exceptions.add(new TaskOperationFailure(TransportTasksAction.this.clusterService.localNode().getId(), ((Task)operationTask).getId(), e));
                }
            }

            @Override
            protected NodeTasksResponse onCompletion() {
                return new NodeTasksResponse(TransportTasksAction.this.clusterService.localNode().getId(), this.results, this.exceptions);
            }

            public String toString() {
                return TransportTasksAction.this.transportNodeAction;
            }
        }.run(nodeTask, operationTasks.iterator(), listener);
    }

    protected String[] resolveNodes(TasksRequest request, DiscoveryNodes discoveryNodes) {
        if (((BaseTasksRequest)request).getTargetTaskId().isSet()) {
            return new String[]{((BaseTasksRequest)request).getTargetTaskId().getNodeId()};
        }
        return discoveryNodes.resolveNodes(((BaseTasksRequest)request).getNodes());
    }

    protected void processTasks(CancellableTask nodeTask, TasksRequest request, ActionListener<List<OperationTask>> nodeOperation) {
        nodeOperation.onResponse(this.processTasks(request));
    }

    protected List<OperationTask> processTasks(TasksRequest request) {
        if (((BaseTasksRequest)request).getTargetTaskId().isSet()) {
            Task task = this.taskManager.getTask(((BaseTasksRequest)request).getTargetTaskId().getId());
            if (task != null) {
                if (((BaseTasksRequest)request).match(task)) {
                    return List.of(task);
                }
                throw new ResourceNotFoundException("task [{}] doesn't support this operation", ((BaseTasksRequest)request).getTargetTaskId());
            }
            throw new ResourceNotFoundException("task [{}] is missing", ((BaseTasksRequest)request).getTargetTaskId());
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (Task task : this.taskManager.getTasks().values()) {
            if (!((BaseTasksRequest)request).match(task)) continue;
            tasks.add(task);
        }
        return tasks;
    }

    protected abstract TasksResponse newResponse(TasksRequest var1, List<TaskResponse> var2, List<TaskOperationFailure> var3, List<FailedNodeException> var4);

    protected abstract void taskOperation(CancellableTask var1, TasksRequest var2, OperationTask var3, ActionListener<TaskResponse> var4);

    class NodeTransportHandler
    implements TransportRequestHandler<NodeTaskRequest> {
        NodeTransportHandler() {
        }

        @Override
        public void messageReceived(NodeTaskRequest request, TransportChannel channel, Task task) throws Exception {
            assert (task instanceof CancellableTask);
            Object tasksRequest = request.tasksRequest;
            TransportTasksAction.this.processTasks((CancellableTask)task, tasksRequest, new ChannelActionListener(channel).delegateFailure((l, tasks) -> TransportTasksAction.this.nodeOperation((CancellableTask)task, (ActionListener<NodeTasksResponse>)l, tasksRequest, tasks)));
        }
    }

    private class NodeTasksResponse
    extends TransportResponse {
        protected String nodeId;
        protected List<TaskOperationFailure> exceptions;
        protected List<TaskResponse> results;

        NodeTasksResponse(StreamInput in) throws IOException {
            int resultsSize;
            super(in);
            this.nodeId = in.readString();
            this.results = new ArrayList(resultsSize);
            for (resultsSize = in.readVInt(); resultsSize > 0; --resultsSize) {
                Writeable result = in.readBoolean() ? (Writeable)TransportTasksAction.this.responseReader.read(in) : null;
                this.results.add(result);
            }
            if (in.readBoolean()) {
                int taskFailures = in.readVInt();
                this.exceptions = new ArrayList<TaskOperationFailure>(taskFailures);
                for (int i = 0; i < taskFailures; ++i) {
                    this.exceptions.add(new TaskOperationFailure(in));
                }
            } else {
                this.exceptions = null;
            }
        }

        NodeTasksResponse(String nodeId, List<TaskResponse> results, List<TaskOperationFailure> exceptions) {
            this.nodeId = nodeId;
            this.results = results;
            this.exceptions = exceptions;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeCollection(this.results, StreamOutput::writeOptionalWriteable);
            out.writeBoolean(this.exceptions != null);
            if (this.exceptions != null) {
                out.writeCollection(this.exceptions);
            }
        }
    }

    private class NodeTaskRequest
    extends TransportRequest {
        private final TasksRequest tasksRequest;

        protected NodeTaskRequest(StreamInput in) throws IOException {
            super(in);
            this.tasksRequest = (BaseTasksRequest)TransportTasksAction.this.requestReader.read(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            assert (((TransportMessage)this.tasksRequest).hasReferences());
            ((BaseTasksRequest)this.tasksRequest).writeTo(out);
        }

        protected NodeTaskRequest(TasksRequest tasksRequest) {
            tasksRequest.mustIncRef();
            this.tasksRequest = tasksRequest;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        @Override
        public void incRef() {
            ((TransportMessage)this.tasksRequest).incRef();
        }

        @Override
        public boolean tryIncRef() {
            return ((TransportMessage)this.tasksRequest).tryIncRef();
        }

        @Override
        public boolean decRef() {
            return ((TransportMessage)this.tasksRequest).decRef();
        }

        @Override
        public boolean hasReferences() {
            return ((TransportMessage)this.tasksRequest).hasReferences();
        }

        @Override
        public String toString() {
            return "[" + TransportTasksAction.this.transportNodeAction + "][" + String.valueOf(this.tasksRequest) + "]";
        }
    }
}

