/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import java.util.List;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.TransportShardRefreshAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.replication.BasicReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportBroadcastReplicationAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.transport.TransportService;

public class TransportRefreshAction
extends TransportBroadcastReplicationAction<RefreshRequest, BroadcastResponse, BasicReplicationRequest, ReplicationResponse> {
    @Inject
    public TransportRefreshAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client) {
        super("indices:admin/refresh", RefreshRequest::new, clusterService, transportService, client, actionFilters, indexNameExpressionResolver, TransportShardRefreshAction.TYPE, transportService.getThreadPool().executor("refresh"));
    }

    @Override
    protected BasicReplicationRequest newShardRequest(RefreshRequest request, ShardId shardId) {
        BasicReplicationRequest replicationRequest = new BasicReplicationRequest(shardId);
        replicationRequest.waitForActiveShards(ActiveShardCount.NONE);
        return replicationRequest;
    }

    @Override
    protected BroadcastResponse newResponse(int successfulShards, int failedShards, int totalNumCopies, List<DefaultShardOperationFailedException> shardFailures) {
        return new BroadcastResponse(totalNumCopies, successfulShards, failedShards, shardFailures);
    }
}

