/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.literal.interval;

import java.io.IOException;
import java.time.Period;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.sql.expression.literal.interval.Interval;
import org.elasticsearch.xpack.sql.expression.literal.interval.Intervals;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class IntervalYearMonth
extends Interval<Period> {
    public static final String NAME = "iym";

    private static Period period(StreamInput in) throws IOException {
        return Period.of(in.readVInt(), in.readVInt(), in.readVInt());
    }

    public IntervalYearMonth(Period interval, DataType intervalType) {
        super(interval, intervalType);
    }

    public IntervalYearMonth(StreamInput in) throws IOException {
        super(IntervalYearMonth.period(in), SqlDataTypes.fromTypeName(in.readString()));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Period p = (Period)this.interval();
        out.writeVInt(p.getYears());
        out.writeVInt(p.getMonths());
        out.writeVInt(p.getDays());
        out.writeString(this.dataType().typeName());
    }

    public String getWriteableName() {
        return NAME;
    }

    public IntervalYearMonth add(Interval<Period> interval) {
        return new IntervalYearMonth(((Period)this.interval()).plus(interval.interval()).normalized(), Intervals.compatibleInterval(this.dataType(), interval.dataType()));
    }

    public IntervalYearMonth sub(Interval<Period> interval) {
        return new IntervalYearMonth(((Period)this.interval()).minus(interval.interval()).normalized(), Intervals.compatibleInterval(this.dataType(), interval.dataType()));
    }

    @Override
    public Interval<Period> mul(long mul) {
        int i = DataTypeConverter.safeToInt((long)mul);
        return new IntervalYearMonth(((Period)this.interval()).multipliedBy(i), this.dataType());
    }

    public String script() {
        return "{sql}.intervalYearMonth({},{})";
    }
}

