/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.lookup;

import java.util.Optional;
import java.util.stream.IntStream;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class RightChunkedLeftJoin
implements Releasable {
    private final Page leftHand;
    private final int mergedElementCount;
    private int next = 0;

    public RightChunkedLeftJoin(Page leftHand, int mergedElementCounts) {
        this.leftHand = leftHand;
        this.mergedElementCount = mergedElementCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page join(Page rightHand) {
        Page page;
        IntVector positions = ((IntBlock)rightHand.getBlock(0)).asVector();
        if (positions.getInt(0) < this.next - 1) {
            throw new IllegalArgumentException("maximum overlap is one position");
        }
        Releasable[] blocks = new Block[this.leftHand.getBlockCount() + this.mergedElementCount];
        if (rightHand.getBlockCount() != this.mergedElementCount + 1) {
            throw new IllegalArgumentException("expected right hand side with [" + (this.mergedElementCount + 1) + "] but got [" + rightHand.getBlockCount() + "]");
        }
        IntVector.Builder leftFilterBuilder = null;
        IntVector leftFilter = null;
        IntVector.Builder insertNullsBuilder = null;
        IntVector insertNulls = null;
        try {
            int b;
            leftFilterBuilder = positions.blockFactory().newIntVectorBuilder(positions.getPositionCount());
            for (int p = 0; p < positions.getPositionCount(); ++p) {
                int pos = positions.getInt(p);
                if (pos > this.next) {
                    if (insertNullsBuilder == null) {
                        insertNullsBuilder = positions.blockFactory().newIntVectorBuilder(pos - this.next);
                    }
                    for (int missing = this.next; missing < pos; ++missing) {
                        leftFilterBuilder.appendInt(missing);
                        insertNullsBuilder.appendInt(p);
                    }
                }
                leftFilterBuilder.appendInt(pos);
                this.next = pos + 1;
            }
            leftFilter = leftFilterBuilder.build();
            int[] leftFilterArray = this.toArray(leftFilter);
            insertNulls = insertNullsBuilder == null ? null : insertNullsBuilder.build();
            for (b = 0; b < this.leftHand.getBlockCount(); ++b) {
                blocks[b] = this.leftHand.getBlock(b).filter(leftFilterArray);
            }
            int rb = 1;
            while (b < blocks.length) {
                Object block = rightHand.getBlock(rb);
                if (insertNulls == null) {
                    block.mustIncRef();
                } else {
                    block = block.insertNulls(insertNulls);
                }
                blocks[b] = block;
                ++b;
                ++rb;
            }
            Page result = new Page((Block[])blocks);
            blocks = null;
            page = result;
        }
        catch (Throwable throwable) {
            Releasables.close((Releasable[])new Releasable[]{blocks == null ? null : Releasables.wrap((Releasable[])blocks), leftFilter, leftFilterBuilder, insertNullsBuilder, insertNulls});
            throw throwable;
        }
        Releasables.close((Releasable[])new Releasable[]{blocks == null ? null : Releasables.wrap((Releasable[])blocks), leftFilter, leftFilterBuilder, insertNullsBuilder, insertNulls});
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Page> noMoreRightHandPages() {
        if (this.next == this.leftHand.getPositionCount()) {
            return Optional.empty();
        }
        BlockFactory factory = this.leftHand.getBlock(0).blockFactory();
        Releasable[] blocks = new Block[this.leftHand.getBlockCount() + this.mergedElementCount];
        int[] filter = IntStream.range(this.next, this.leftHand.getPositionCount()).toArray();
        try {
            int b;
            for (b = 0; b < this.leftHand.getBlockCount(); ++b) {
                blocks[b] = this.leftHand.getBlock(b).filter(filter);
            }
            while (b < blocks.length) {
                blocks[b] = factory.newConstantNullBlock(this.leftHand.getPositionCount() - this.next);
                ++b;
            }
            Page result = new Page((Block[])blocks);
            blocks = null;
            Optional<Page> optional = Optional.of(result);
            return optional;
        }
        finally {
            if (blocks != null) {
                Releasables.close((Releasable[])blocks);
            }
        }
    }

    public void releaseOnAnyThread() {
        this.leftHand.allowPassingToDifferentDriver();
        this.leftHand.releaseBlocks();
    }

    public void close() {
        Releasables.close(this.leftHand::releaseBlocks);
    }

    private int[] toArray(IntVector vector) {
        int[] array = new int[vector.getPositionCount()];
        for (int p = 0; p < vector.getPositionCount(); ++p) {
            array[p] = vector.getInt(p);
        }
        return array;
    }
}

