/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileFloatAggregatorFunction;
import org.elasticsearch.compute.aggregation.PercentileFloatGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class PercentileFloatAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final List<Integer> channels;
    private final double percentile;

    public PercentileFloatAggregatorFunctionSupplier(List<Integer> channels, double percentile) {
        this.channels = channels;
        this.percentile = percentile;
    }

    @Override
    public PercentileFloatAggregatorFunction aggregator(DriverContext driverContext) {
        return PercentileFloatAggregatorFunction.create(driverContext, this.channels, this.percentile);
    }

    @Override
    public PercentileFloatGroupingAggregatorFunction groupingAggregator(DriverContext driverContext) {
        return PercentileFloatGroupingAggregatorFunction.create(this.channels, driverContext, this.percentile);
    }

    @Override
    public String describe() {
        return "percentile of floats";
    }
}

