/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor;

import java.util.Collection;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregatedSearchRequestBuilder;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.CompositeAggregationDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.RollupDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.chunked.ChunkedDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ScrollDataExtractorFactory;

public interface DataExtractorFactory {
    public DataExtractor newExtractor(long var1, long var3);

    public static void create(Client client, DatafeedConfig datafeed, Job job, NamedXContentRegistry xContentRegistry, DatafeedTimingStatsReporter timingStatsReporter, ActionListener<DataExtractorFactory> listener) {
        DataExtractorFactory.create(client, datafeed, null, job, xContentRegistry, timingStatsReporter, listener);
    }

    public static void create(Client client, DatafeedConfig datafeed, QueryBuilder extraFilters, Job job, NamedXContentRegistry xContentRegistry, DatafeedTimingStatsReporter timingStatsReporter, ActionListener<DataExtractorFactory> listener) {
        boolean hasAggs = datafeed.hasAggregations();
        boolean isComposite = hasAggs && datafeed.hasCompositeAgg(xContentRegistry);
        ActionListener factoryHandler = listener.delegateFailureAndWrap((l, factory) -> l.onResponse((Object)(datafeed.getChunkingConfig().isEnabled() ? new ChunkedDataExtractorFactory(datafeed, job, xContentRegistry, (DataExtractorFactory)factory) : factory)));
        ActionListener getRollupIndexCapsActionHandler = ActionListener.wrap(response -> {
            boolean hasRollup;
            boolean bl = hasRollup = !response.getJobs().isEmpty();
            if (hasRollup && !hasAggs) {
                listener.onFailure((Exception)new IllegalArgumentException("Aggregations are required when using Rollup indices"));
                return;
            }
            if (!hasAggs) {
                ScrollDataExtractorFactory.create(client, datafeed, extraFilters, job, xContentRegistry, timingStatsReporter, (ActionListener<DataExtractorFactory>)factoryHandler);
                return;
            }
            if (hasRollup && !datafeed.getRuntimeMappings().isEmpty()) {
                listener.onFailure((Exception)new IllegalArgumentException("The datafeed has runtime_mappings defined, runtime fields are not supported in rollup searches"));
                return;
            }
            if (isComposite) {
                String[] indices = datafeed.getIndices().toArray(new String[0]);
                IndicesOptions indicesOptions = datafeed.getIndicesOptions();
                AggregatedSearchRequestBuilder aggregatedSearchRequestBuilder = hasRollup ? RollupDataExtractorFactory.requestBuilder(client, indices, indicesOptions) : AggregationDataExtractorFactory.requestBuilder(client, indices, indicesOptions);
                CompositeAggregationDataExtractorFactory dataExtractorFactory = new CompositeAggregationDataExtractorFactory(client, datafeed, extraFilters, job, xContentRegistry, timingStatsReporter, aggregatedSearchRequestBuilder);
                if (datafeed.getChunkingConfig().isManual()) {
                    factoryHandler.onResponse((Object)dataExtractorFactory);
                } else {
                    listener.onResponse((Object)dataExtractorFactory);
                }
                return;
            }
            if (hasRollup) {
                RollupDataExtractorFactory.create(client, datafeed, extraFilters, job, response.getJobs(), xContentRegistry, timingStatsReporter, (ActionListener<DataExtractorFactory>)factoryHandler);
            } else {
                factoryHandler.onResponse((Object)new AggregationDataExtractorFactory(client, datafeed, extraFilters, job, xContentRegistry, timingStatsReporter));
            }
        }, e -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof IndexNotFoundException) {
                IndexNotFoundException notFound = (IndexNotFoundException)cause;
                listener.onFailure((Exception)((Object)new ResourceNotFoundException("datafeed [" + datafeed.getId() + "] cannot retrieve data because index " + String.valueOf(notFound.getIndex()) + " does not exist", new Object[0])));
            } else {
                listener.onFailure(e);
            }
        });
        if (RemoteClusterLicenseChecker.containsRemoteIndex((Collection)datafeed.getIndices())) {
            getRollupIndexCapsActionHandler.onResponse((Object)new GetRollupIndexCapsAction.Response());
        } else {
            ClientHelper.executeAsyncWithOrigin((Client)client, (String)"ml", (ActionType)GetRollupIndexCapsAction.INSTANCE, (ActionRequest)new GetRollupIndexCapsAction.Request(datafeed.getIndices().toArray(new String[0]), datafeed.getIndicesOptions()), (ActionListener)getRollupIndexCapsActionHandler);
        }
    }
}

