/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.Iterator;
import org.ojalgo.ProgrammingError;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.AccessAnyD;
import org.ojalgo.structure.Structure2D;

public class VectorView<N extends Comparable<N>>
implements Access1D<N>,
Iterable<VectorView<N>>,
Iterator<VectorView<N>>,
Comparable<VectorView<N>> {
    private final long myCount;
    private final AccessAnyD<N> myDelegateAnyD;
    private final long myLastOffset;
    private long myOffset;

    protected VectorView(AccessAnyD<N> access) {
        this(access, -1L);
    }

    VectorView(AccessAnyD<N> access, long index) {
        this.myDelegateAnyD = access;
        this.myCount = access.count(0);
        this.myOffset = index * this.myCount;
        this.myLastOffset = this.myDelegateAnyD.count() - this.myCount;
    }

    @Override
    public int compareTo(VectorView<N> other) {
        return Long.compare(this.myOffset, other.getOffset());
    }

    @Override
    public long count() {
        return this.myCount;
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegateAnyD.doubleValue(this.myOffset + Structure2D.index(this.myCount, index, 0L));
    }

    public long estimateSize() {
        return (this.myLastOffset - this.myOffset) / this.myCount;
    }

    @Override
    public N get(long index) {
        return this.myDelegateAnyD.get(this.myOffset + Structure2D.index(this.myCount, index, 0L));
    }

    @Override
    public boolean hasNext() {
        return this.myOffset < this.myLastOffset;
    }

    public boolean hasPrevious() {
        return this.myOffset > 0L;
    }

    public long index() {
        return this.myOffset / this.myCount;
    }

    @Override
    public VectorView<N> iterator() {
        return new VectorView<N>(this.myDelegateAnyD);
    }

    @Override
    public VectorView<N> next() {
        this.myOffset += this.myCount;
        return this;
    }

    public VectorView<N> previous() {
        this.myOffset -= this.myCount;
        return this;
    }

    @Override
    public final void remove() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    public final String toString() {
        return this.index() + " = " + Access1D.toString(this);
    }

    protected void setIndex(long matrix) {
        this.myOffset = matrix * this.myCount;
    }

    long getOffset() {
        return this.myOffset;
    }
}

