/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.AbstractContinuous;

public class Exponential
extends AbstractContinuous {
    private final double myRate;

    public static Exponential of(double rate) {
        return new Exponential(rate);
    }

    public Exponential() {
        this(PrimitiveMath.ONE);
    }

    public Exponential(double rate) {
        this.myRate = rate;
    }

    @Override
    public double getDensity(double value) {
        if (value < PrimitiveMath.ZERO) {
            return PrimitiveMath.ZERO;
        }
        return this.myRate * PrimitiveMath.EXP.invoke(-this.myRate * value);
    }

    @Override
    public double getDistribution(double value) {
        if (value < PrimitiveMath.ZERO) {
            return PrimitiveMath.ZERO;
        }
        return PrimitiveMath.ONE - PrimitiveMath.EXP.invoke(-this.myRate * value);
    }

    @Override
    public double getExpected() {
        return PrimitiveMath.ONE / this.myRate;
    }

    @Override
    public double getQuantile(double probability) {
        this.checkProbabilty(probability);
        return PrimitiveMath.LOG.invoke(PrimitiveMath.ONE - probability) / -this.myRate;
    }

    @Override
    public double getStandardDeviation() {
        return PrimitiveMath.ONE / this.myRate;
    }

    @Override
    protected double generate() {
        return -PrimitiveMath.LOG.invoke(this.random().nextDouble()) / this.myRate;
    }
}

