/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.alibabacloudsearch.completion;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.completion.AlibabaCloudSearchCompletionTaskSettings;

public record AlibabaCloudSearchCompletionRequestEntity(List<String> messages, AlibabaCloudSearchCompletionTaskSettings taskSettings, @Nullable String model) implements ToXContentObject
{
    private static final String MESSAGE = "messages";
    private static final String PARAMETERS = "parameters";
    private static final String ROLE_FIELD = "role";
    private static final String ROLE_USER = "user";
    private static final String ROLE_ASSISTANT = "assistant";
    private static final String CONTENT_FIELD = "content";

    public AlibabaCloudSearchCompletionRequestEntity {
        Objects.requireNonNull(messages);
        Objects.requireNonNull(taskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(MESSAGE);
        for (int i = 0; i < this.messages.size(); ++i) {
            builder.startObject();
            String roleValue = i % 2 == 0 ? ROLE_USER : ROLE_ASSISTANT;
            builder.field(ROLE_FIELD, roleValue);
            builder.field(CONTENT_FIELD, this.messages.get(i));
            builder.endObject();
        }
        builder.endArray();
        if (this.taskSettings.getParameters() != null) {
            builder.field(PARAMETERS, this.taskSettings.getParameters());
        }
        builder.endObject();
        return builder;
    }
}

