/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.anthropic;

import java.util.concurrent.Flow;
import org.apache.http.HttpResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.inference.external.anthropic.AnthropicStreamingProcessor;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandlerUtils;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.ErrorMessageResponseEntity;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;

public class AnthropicResponseHandler
extends BaseResponseHandler {
    static final String REQUESTS_LIMIT = "anthropic-ratelimit-requests-limit";
    static final String REMAINING_REQUESTS = "anthropic-ratelimit-requests-remaining";
    static final String REQUEST_RESET = "anthropic-ratelimit-requests-reset";
    static final String TOKENS_LIMIT = "anthropic-ratelimit-tokens-limit";
    static final String REMAINING_TOKENS = "anthropic-ratelimit-tokens-remaining";
    static final String TOKENS_RESET = "anthropic-ratelimit-tokens-reset";
    static final String RETRY_AFTER = "retry-after";
    static final String SERVER_BUSY = "Received an Anthropic server is temporarily overloaded status code";
    private final boolean canHandleStreamingResponses;

    public AnthropicResponseHandler(String requestType, ResponseParser parseFunction, boolean canHandleStreamingResponses) {
        super(requestType, parseFunction, ErrorMessageResponseEntity::fromResponse);
        this.canHandleStreamingResponses = canHandleStreamingResponses;
    }

    @Override
    public boolean canHandleStreamingResponses() {
        return this.canHandleStreamingResponses;
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        ServerSentEventProcessor sseProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        AnthropicStreamingProcessor anthropicProcessor = new AnthropicStreamingProcessor();
        sseProcessor.subscribe(anthropicProcessor);
        flow.subscribe(sseProcessor);
        return new StreamingChatCompletionResults((Flow.Publisher)anthropicProcessor);
    }

    @Override
    protected void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return;
        }
        if (statusCode == 500) {
            throw new RetryException(true, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 529) {
            throw new RetryException(true, this.buildError(SERVER_BUSY, request, result));
        }
        if (statusCode > 500) {
            throw new RetryException(false, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 429) {
            throw new RetryException(true, this.buildError(AnthropicResponseHandler.buildRateLimitErrorMessage(result), request, result));
        }
        if (statusCode == 403) {
            throw new RetryException(false, this.buildError("Received a permission denied error status code", request, result));
        }
        if (statusCode == 401) {
            throw new RetryException(false, this.buildError("Received an authentication error status code", request, result));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }

    static String buildRateLimitErrorMessage(HttpResult result) {
        HttpResponse response = result.response();
        String tokenLimit = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, TOKENS_LIMIT);
        String remainingTokens = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REMAINING_TOKENS);
        String requestLimit = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REQUESTS_LIMIT);
        String remainingRequests = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REMAINING_REQUESTS);
        String requestReset = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REQUEST_RESET);
        String tokensReset = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, TOKENS_RESET);
        String retryAfter = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, RETRY_AFTER);
        String usageMessage = Strings.format((String)"Token limit [%s], remaining tokens [%s], tokens reset [%s]. Request limit [%s], remaining requests [%s], request reset [%s]. Retry after [%s]", (Object[])new Object[]{tokenLimit, remainingTokens, tokensReset, requestLimit, remainingRequests, requestReset, retryAfter});
        return "Received a rate limit status code. " + usageMessage;
    }
}

