/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.eql.util.SearchHitUtils;

public class HitReference
implements Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(HitReference.class);
    private final String index;
    private final String id;

    public HitReference(String index, String id) {
        this.index = index;
        this.id = id;
    }

    public HitReference(SearchHit hit) {
        this(SearchHitUtils.qualifiedIndex(hit), hit.getId());
    }

    public String index() {
        return this.index;
    }

    public String id() {
        return this.id;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf((String)this.id);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HitReference other = (HitReference)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "doc[" + this.index + "][" + this.id + "]";
    }
}

