/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.ArrayNumber;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.EightBytesOfData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.FourBytesOfData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.IProperty;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.NoData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.OneByteOfData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.PrtArrayOfPropertyValues;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.PrtFourBytesOfLengthFollowedByData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.property.TwoBytesOfData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.PropertyID;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.PropertyType;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitConverter;

public class PropertySet
implements IProperty {
    public int cProperties;
    public PropertyID[] rgPrids;
    public List<IProperty> rgData;

    @Override
    public List<Byte> serializeToByteList() throws IOException {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        for (byte b : BitConverter.getBytes(this.cProperties)) {
            byteList.add(b);
        }
        for (byte propertyId : (Object)this.rgPrids) {
            byteList.addAll(propertyId.serializeToByteList());
        }
        Object object = this.rgData.iterator();
        while (object.hasNext()) {
            IProperty property = (IProperty)object.next();
            byteList.addAll(property.serializeToByteList());
        }
        return byteList;
    }

    @Override
    public int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws IOException {
        int index = startIndex;
        this.cProperties = BitConverter.toInt16(byteArray, startIndex);
        index += 2;
        this.rgPrids = new PropertyID[this.cProperties];
        for (int i = 0; i < this.cProperties; ++i) {
            PropertyID propertyID = new PropertyID();
            propertyID.doDeserializeFromByteArray(byteArray, index);
            this.rgPrids[i] = propertyID;
            index += 4;
        }
        this.rgData = new ArrayList<IProperty>();
        for (PropertyID propertyID : this.rgPrids) {
            IProperty property = null;
            switch (PropertyType.fromIntVal(propertyID.type)) {
                case NoData: 
                case Bool: 
                case ObjectID: 
                case ContextID: 
                case ObjectSpaceID: {
                    property = new NoData();
                    break;
                }
                case ArrayOfObjectIDs: 
                case ArrayOfObjectSpaceIDs: 
                case ArrayOfContextIDs: {
                    property = new ArrayNumber();
                    break;
                }
                case OneByteOfData: {
                    property = new OneByteOfData();
                    break;
                }
                case TwoBytesOfData: {
                    property = new TwoBytesOfData();
                    break;
                }
                case FourBytesOfData: {
                    property = new FourBytesOfData();
                    break;
                }
                case EightBytesOfData: {
                    property = new EightBytesOfData();
                    break;
                }
                case FourBytesOfLengthFollowedByData: {
                    property = new PrtFourBytesOfLengthFollowedByData();
                    break;
                }
                case ArrayOfPropertyValues: {
                    property = new PrtArrayOfPropertyValues();
                    break;
                }
                case PropertySet: {
                    property = new PropertySet();
                    break;
                }
            }
            if (property == null) continue;
            int len = property.doDeserializeFromByteArray(byteArray, index);
            this.rgData.add(property);
            index += len;
        }
        return index - startIndex;
    }
}

