/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.monitoring.MonitoringDeprecatedSettings;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;

public class NodeDeprecationChecks {
    static final List<NodeDeprecationCheck<Settings, PluginsAndModules, ClusterState, XPackLicenseState, DeprecationIssue>> SINGLE_NODE_CHECKS = List.of(NodeDeprecationChecks::checkMultipleDataPaths, NodeDeprecationChecks::checkDataPathsList, NodeDeprecationChecks::checkSharedDataPathSetting, NodeDeprecationChecks::checkReservedPrefixedRealmNames, NodeDeprecationChecks::checkSingleDataNodeWatermarkSetting, NodeDeprecationChecks::checkExporterUseIngestPipelineSettings, NodeDeprecationChecks::checkExporterPipelineMasterTimeoutSetting, NodeDeprecationChecks::checkExporterCreateLegacyTemplateSetting, NodeDeprecationChecks::checkMonitoringSettingHistoryDuration, NodeDeprecationChecks::checkMonitoringSettingHistoryDuration, NodeDeprecationChecks::checkMonitoringSettingCollectIndexRecovery, NodeDeprecationChecks::checkMonitoringSettingCollectIndices, NodeDeprecationChecks::checkMonitoringSettingCollectCcrTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectEnrichStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectIndexRecoveryStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectIndexStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectMlJobStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectNodeStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingCollectClusterStatsTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersHost, NodeDeprecationChecks::checkMonitoringSettingExportersBulkTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersConnectionTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersConnectionReadTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersAuthUsername, NodeDeprecationChecks::checkMonitoringSettingExportersAuthPass, NodeDeprecationChecks::checkMonitoringSettingExportersSSL, NodeDeprecationChecks::checkMonitoringSettingExportersProxyBase, NodeDeprecationChecks::checkMonitoringSettingExportersSniffEnabled, NodeDeprecationChecks::checkMonitoringSettingExportersHeaders, NodeDeprecationChecks::checkMonitoringSettingExportersTemplateTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersMasterTimeout, NodeDeprecationChecks::checkMonitoringSettingExportersEnabled, NodeDeprecationChecks::checkMonitoringSettingExportersType, NodeDeprecationChecks::checkMonitoringSettingExportersAlertsEnabled, NodeDeprecationChecks::checkMonitoringSettingExportersAlertsBlacklist, NodeDeprecationChecks::checkMonitoringSettingExportersIndexNameTimeFormat, NodeDeprecationChecks::checkMonitoringSettingDecommissionAlerts, NodeDeprecationChecks::checkMonitoringSettingEsCollectionEnabled, NodeDeprecationChecks::checkMonitoringSettingCollectionEnabled, NodeDeprecationChecks::checkMonitoringSettingCollectionInterval, NodeDeprecationChecks::checkScriptContextCache, NodeDeprecationChecks::checkScriptContextCompilationsRateLimitSetting, NodeDeprecationChecks::checkScriptContextCacheSizeSetting, NodeDeprecationChecks::checkScriptContextCacheExpirationSetting, NodeDeprecationChecks::checkEnforceDefaultTierPreferenceSetting, NodeDeprecationChecks::checkLifecyleStepMasterTimeoutSetting, NodeDeprecationChecks::checkEqlEnabledSetting, NodeDeprecationChecks::checkNodeAttrData, NodeDeprecationChecks::checkWatcherBulkConcurrentRequestsSetting, NodeDeprecationChecks::checkTracingApmSettings);
    private static final String MONITORING_SETTING_DEPRECATION_LINK = "https://ela.st/es-deprecation-7-monitoring-settings";
    private static final String MONITORING_SETTING_REMOVAL_TIME = "after 8.0";

    static DeprecationIssue checkDeprecatedSetting(Settings clusterSettings, Settings nodeSettings, Setting<?> deprecatedSetting, String url, String whenRemoved) {
        if (!deprecatedSetting.exists(clusterSettings) && !deprecatedSetting.exists(nodeSettings)) {
            return null;
        }
        String deprecatedSettingKey = deprecatedSetting.getKey();
        String value = deprecatedSetting.exists(clusterSettings) ? deprecatedSetting.get(clusterSettings).toString() : deprecatedSetting.get(nodeSettings).toString();
        String message = String.format(Locale.ROOT, "setting [%s] is deprecated and will be removed " + whenRemoved, deprecatedSettingKey);
        String details = String.format(Locale.ROOT, "the setting [%s] is currently set to [%s], remove this setting", deprecatedSettingKey, value);
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, message, url, details, false, null);
    }

    private static Map<String, Object> createMetaMapForRemovableSettings(boolean canAutoRemoveSetting, String removableSetting) {
        return NodeDeprecationChecks.createMetaMapForRemovableSettings(canAutoRemoveSetting, Collections.singletonList(removableSetting));
    }

    private static Map<String, Object> createMetaMapForRemovableSettings(boolean canAutoRemoveSetting, List<String> removableSettings) {
        return canAutoRemoveSetting ? DeprecationIssue.createMetaMapForRemovableSettings(removableSettings) : null;
    }

    static DeprecationIssue checkRemovedSetting(Settings clusterSettings, Settings nodeSettings, Setting<?> removedSetting, String url, String additionalDetailMessage, DeprecationIssue.Level deprecationLevel) {
        if (!removedSetting.exists(clusterSettings) && !removedSetting.exists(nodeSettings)) {
            return null;
        }
        String removedSettingKey = removedSetting.getKey();
        if (removedSetting.exists(clusterSettings)) {
            removedSetting.get(clusterSettings);
        } else {
            removedSetting.get(nodeSettings);
        }
        String message = String.format(Locale.ROOT, "Setting [%s] is deprecated", removedSettingKey);
        String details = additionalDetailMessage == null ? String.format(Locale.ROOT, "Remove the [%s] setting.", removedSettingKey) : String.format(Locale.ROOT, "Remove the [%s] setting. %s", removedSettingKey, additionalDetailMessage);
        boolean canAutoRemoveSetting = removedSetting.exists(clusterSettings) && !removedSetting.exists(nodeSettings);
        Map<String, Object> meta = NodeDeprecationChecks.createMetaMapForRemovableSettings(canAutoRemoveSetting, removedSettingKey);
        return new DeprecationIssue(deprecationLevel, message, url, details, false, meta);
    }

    static DeprecationIssue checkMultipleRemovedSettings(Settings clusterSettings, Settings nodeSettings, List<Setting<?>> removedSettings, String url, String additionalDetailMessage, DeprecationIssue.Level deprecationLevel) {
        List<Setting> removedSettingsRemaining = removedSettings.stream().filter(s -> s.exists(clusterSettings) || s.exists(nodeSettings)).toList();
        if (removedSettingsRemaining.isEmpty()) {
            return null;
        }
        if (removedSettingsRemaining.size() == 1) {
            Setting removedSetting = removedSettingsRemaining.get(0);
            return NodeDeprecationChecks.checkRemovedSetting(clusterSettings, nodeSettings, removedSetting, url, additionalDetailMessage, deprecationLevel);
        }
        removedSettingsRemaining.forEach(s -> {
            if (s.exists(clusterSettings)) {
                s.get(clusterSettings);
            } else {
                s.get(nodeSettings);
            }
        });
        List<String> removedSettingKeysRemaining = removedSettingsRemaining.stream().map(Setting::getKey).sorted().toList();
        String message = String.format(Locale.ROOT, "Settings %s are deprecated", removedSettingKeysRemaining);
        String details = additionalDetailMessage == null ? String.format(Locale.ROOT, "Remove each setting in %s.", removedSettingKeysRemaining) : String.format(Locale.ROOT, "Remove each setting in %s. %s", removedSettingKeysRemaining, additionalDetailMessage);
        boolean canAutoRemoveSettings = removedSettingsRemaining.stream().allMatch(s -> s.exists(clusterSettings) && !s.exists(nodeSettings));
        Map<String, Object> meta = NodeDeprecationChecks.createMetaMapForRemovableSettings(canAutoRemoveSettings, removedSettingKeysRemaining);
        return new DeprecationIssue(deprecationLevel, message, url, details, false, meta);
    }

    static DeprecationIssue checkMultipleDataPaths(Settings nodeSettings, PluginsAndModules plugins, ClusterState clusterState, XPackLicenseState licenseState) {
        List dataPaths = (List)Environment.PATH_DATA_SETTING.get(nodeSettings);
        if (dataPaths.size() > 1) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Specifying multiple data paths is deprecated", "https://ela.st/es-deprecation-7-multiple-paths", "The [path.data] setting contains a list of paths. Specify a single path as a string. Use RAID or other system level features to utilize multiple disks. If multiple data paths are configured, the node will fail to start in 8.0.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkDataPathsList(Settings nodeSettings, PluginsAndModules plugins, ClusterState clusterState, XPackLicenseState licenseState) {
        if (Environment.dataPathUsesList((Settings)nodeSettings)) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Multiple data paths are not supported", "https://ela.st/es-deprecation-7-multiple-paths", "The [path.data] setting contains a list of paths. Specify a single path as a string. Use RAID or other system level features to utilize multiple disks. If multiple data paths are configured, the node will fail to start in 8.0.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkSharedDataPathSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        if (Environment.PATH_SHARED_DATA_SETTING.exists(settings)) {
            String message = String.format(Locale.ROOT, "setting [%s] is deprecated and will be removed in a future version", Environment.PATH_SHARED_DATA_SETTING.getKey());
            String url = "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/breaking-changes-7.13.html#deprecate-shared-data-path-setting";
            String details = "Found shared data path configured. Discontinue use of this setting.";
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, message, "https://www.elastic.co/guide/en/elasticsearch/reference/7.13/breaking-changes-7.13.html#deprecate-shared-data-path-setting", "Found shared data path configured. Discontinue use of this setting.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkReservedPrefixedRealmNames(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Map realmSettings = RealmSettings.getRealmSettings((Settings)settings);
        if (realmSettings.isEmpty()) {
            return null;
        }
        ArrayList<RealmConfig.RealmIdentifier> reservedPrefixedRealmIdentifiers = new ArrayList<RealmConfig.RealmIdentifier>();
        for (RealmConfig.RealmIdentifier realmIdentifier : realmSettings.keySet()) {
            if (!realmIdentifier.getName().startsWith("_")) continue;
            reservedPrefixedRealmIdentifiers.add(realmIdentifier);
        }
        if (reservedPrefixedRealmIdentifiers.isEmpty()) {
            return null;
        }
        return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Realm that start with [_] will not be permitted in a future major release.", "https://www.elastic.co/guide/en/elasticsearch/reference/7.14/deprecated-7.14.html#reserved-prefixed-realm-names", String.format(Locale.ROOT, "Found realm " + (reservedPrefixedRealmIdentifiers.size() == 1 ? "name" : "names") + " with reserved prefix [%s]: [%s]. In a future major release, node will fail to start if any realm names start with reserved prefix.", "_", reservedPrefixedRealmIdentifiers.stream().map(rid -> "xpack.security.authc.realms." + rid.getType() + "." + rid.getName()).sorted().collect(Collectors.joining("; "))), false, null);
    }

    static DeprecationIssue checkSingleDataNodeWatermarkSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        if (DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.exists(settings)) {
            String key = DiskThresholdDecider.ENABLE_FOR_SINGLE_DATA_NODE.getKey();
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, String.format(Locale.ROOT, "setting [%s] is deprecated and will not be available in a future version", key), "https://www.elastic.co/guide/en/elasticsearch/reference/7.14/breaking-changes-7.14.html#deprecate-single-data-node-watermark", String.format(Locale.ROOT, "found [%s] configured. Discontinue use of this setting.", key), false, null);
        }
        return null;
    }

    private static DeprecationIssue deprecatedAffixSetting(Setting.AffixSetting<?> deprecatedAffixSetting, String detailPattern, String url, DeprecationIssue.Level warningLevel, Settings clusterSettings, Settings nodeSettings) {
        List<Setting> deprecatedConcreteNodeSettings = deprecatedAffixSetting.getAllConcreteSettings(nodeSettings).sorted(Comparator.comparing(Setting::getKey)).toList();
        List<Setting> deprecatedConcreteClusterSettings = deprecatedAffixSetting.getAllConcreteSettings(clusterSettings).sorted(Comparator.comparing(Setting::getKey)).toList();
        if (deprecatedConcreteNodeSettings.isEmpty() && deprecatedConcreteClusterSettings.isEmpty()) {
            return null;
        }
        List<String> deprecatedNodeSettingKeys = deprecatedConcreteNodeSettings.stream().map(Setting::getKey).toList();
        List<String> deprecatedClusterSettingKeys = deprecatedConcreteClusterSettings.stream().map(Setting::getKey).toList();
        String concatSettingNames = Stream.concat(deprecatedNodeSettingKeys.stream(), deprecatedClusterSettingKeys.stream()).distinct().collect(Collectors.joining(","));
        String message = String.format(Locale.ROOT, "The [%s] settings are deprecated and will be removed after 8.0", concatSettingNames);
        String details = String.format(Locale.ROOT, detailPattern, concatSettingNames);
        Map meta = null;
        return new DeprecationIssue(warningLevel, message, url, details, false, meta);
    }

    private static DeprecationIssue deprecatedAffixGroupedSetting(Setting.AffixSetting<Settings> deprecatedAffixSetting, String detailPattern, String url, DeprecationIssue.Level warningLevel, Settings clusterSettings, Settings nodeSettings) {
        List<Setting> deprecatedConcreteNodeSettings = deprecatedAffixSetting.getAllConcreteSettings(nodeSettings).sorted(Comparator.comparing(Setting::getKey)).toList();
        List<Setting> deprecatedConcreteClusterSettings = deprecatedAffixSetting.getAllConcreteSettings(clusterSettings).sorted(Comparator.comparing(Setting::getKey)).toList();
        if (deprecatedConcreteNodeSettings.isEmpty() && deprecatedConcreteClusterSettings.isEmpty()) {
            return null;
        }
        String groupSettingNames = Stream.concat(deprecatedConcreteNodeSettings.stream(), deprecatedConcreteClusterSettings.stream()).map(Setting::getKey).distinct().map(key -> key + "*").collect(Collectors.joining(","));
        List allNodeSubSettingKeys = deprecatedConcreteNodeSettings.stream().flatMap(affixSetting -> {
            String groupPrefix = affixSetting.getKey();
            Settings groupSettings = (Settings)affixSetting.get(nodeSettings);
            Set subSettings = groupSettings.keySet();
            return subSettings.stream().map(key -> groupPrefix + key);
        }).sorted().toList();
        List allClusterSubSettingKeys = deprecatedConcreteClusterSettings.stream().flatMap(affixSetting -> {
            String groupPrefix = affixSetting.getKey();
            Settings groupSettings = (Settings)affixSetting.get(clusterSettings);
            Set subSettings = groupSettings.keySet();
            return subSettings.stream().map(key -> groupPrefix + key);
        }).sorted().toList();
        String allSubSettings = Stream.concat(allNodeSubSettingKeys.stream(), allClusterSubSettingKeys.stream()).distinct().sorted().collect(Collectors.joining(","));
        String message = String.format(Locale.ROOT, "The [%s] settings are deprecated and will be removed after 8.0", groupSettingNames);
        String details = String.format(Locale.ROOT, detailPattern, allSubSettings);
        Map meta = null;
        return new DeprecationIssue(warningLevel, message, url, details, false, meta);
    }

    static DeprecationIssue genericMonitoringSetting(ClusterState clusterState, Settings nodeSettings, Setting<?> deprecated) {
        return NodeDeprecationChecks.checkDeprecatedSetting(clusterState.metadata().settings(), nodeSettings, deprecated, MONITORING_SETTING_DEPRECATION_LINK, MONITORING_SETTING_REMOVAL_TIME);
    }

    static DeprecationIssue genericMonitoringAffixSetting(Settings clusterSettings, Settings nodeSettings, String deprecatedSuffix) {
        return NodeDeprecationChecks.deprecatedAffixSetting(Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)deprecatedSuffix, x$0 -> Setting.simpleString((String)x$0, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]), "Remove the following settings: [%s]", MONITORING_SETTING_DEPRECATION_LINK, DeprecationIssue.Level.WARNING, clusterSettings, nodeSettings);
    }

    static DeprecationIssue genericMonitoringAffixSecureSetting(Settings clusterSettings, Settings nodeSettings, String deprecatedSuffix) {
        return NodeDeprecationChecks.deprecatedAffixSetting(Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)deprecatedSuffix, k -> SecureSetting.secureString((String)k, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]), "Remove the following settings from the keystore: [%s]", MONITORING_SETTING_DEPRECATION_LINK, DeprecationIssue.Level.WARNING, clusterSettings, nodeSettings);
    }

    static DeprecationIssue genericMonitoringAffixGroupedSetting(Settings clusterSettings, Settings nodeSettings, String deprecatedSuffix) {
        return NodeDeprecationChecks.deprecatedAffixGroupedSetting((Setting.AffixSetting<Settings>)Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)deprecatedSuffix, k -> Setting.groupSetting((String)(k + "."), (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]), "Remove the following settings: [%s]", MONITORING_SETTING_DEPRECATION_LINK, DeprecationIssue.Level.WARNING, clusterSettings, nodeSettings);
    }

    static DeprecationIssue checkMonitoringSettingHistoryDuration(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.history.duration", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectIndexRecovery(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.collection.index.recovery.active_only", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectIndices(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.collection.indices", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectCcrTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.collection.ccr.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectEnrichStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.collection.enrich.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectIndexRecoveryStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.collection.index.recovery.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectIndexStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.collection.index.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectMlJobStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.collection.ml.job.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectNodeStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.collection.node.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectClusterStatsTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.collection.cluster.stats.timeout", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingExportersHost(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "host");
    }

    static DeprecationIssue checkMonitoringSettingExportersBulkTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "bulk.timeout");
    }

    static DeprecationIssue checkMonitoringSettingExportersConnectionTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "connection.timeout");
    }

    static DeprecationIssue checkMonitoringSettingExportersConnectionReadTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "connection.read_timeout");
    }

    static DeprecationIssue checkMonitoringSettingExportersAuthUsername(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "auth.username");
    }

    static DeprecationIssue checkMonitoringSettingExportersAuthPass(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSecureSetting(clusterState.metadata().settings(), settings, "auth.secure_password");
    }

    static DeprecationIssue checkMonitoringSettingExportersSSL(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixGroupedSetting(clusterState.metadata().settings(), settings, "ssl");
    }

    static DeprecationIssue checkMonitoringSettingExportersProxyBase(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "proxy.base_path");
    }

    static DeprecationIssue checkMonitoringSettingExportersSniffEnabled(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "sniff.enabled");
    }

    static DeprecationIssue checkMonitoringSettingExportersHeaders(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixGroupedSetting(clusterState.metadata().settings(), settings, "headers");
    }

    static DeprecationIssue checkMonitoringSettingExportersTemplateTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "index.template.master_timeout");
    }

    static DeprecationIssue checkMonitoringSettingExportersMasterTimeout(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "wait_master.timeout");
    }

    static DeprecationIssue checkMonitoringSettingExportersEnabled(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "enabled");
    }

    static DeprecationIssue checkMonitoringSettingExportersType(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "type");
    }

    static DeprecationIssue checkMonitoringSettingExportersAlertsEnabled(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "cluster_alerts.management.enabled");
    }

    static DeprecationIssue checkMonitoringSettingExportersAlertsBlacklist(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "cluster_alerts.management.blacklist");
    }

    static DeprecationIssue checkMonitoringSettingExportersIndexNameTimeFormat(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringAffixSetting(clusterState.metadata().settings(), settings, "index.name.time_format");
    }

    static DeprecationIssue checkMonitoringSettingDecommissionAlerts(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.migration.decommission_alerts", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingEsCollectionEnabled(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.elasticsearch.collection.enabled", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectionEnabled(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.collection.enabled", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkMonitoringSettingCollectionInterval(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.genericMonitoringSetting(clusterState, settings, Setting.simpleString((String)"xpack.monitoring.collection.interval", (Setting.Property[])new Setting.Property[0]));
    }

    static DeprecationIssue checkExporterUseIngestPipelineSettings(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.deprecatedAffixSetting(MonitoringDeprecatedSettings.USE_INGEST_PIPELINE_SETTING, "Remove the following settings: [%s]", "https://ela.st/es-deprecation-7-monitoring-exporter-use-ingest-setting", DeprecationIssue.Level.WARNING, clusterState.metadata().settings(), settings);
    }

    static DeprecationIssue checkExporterPipelineMasterTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.deprecatedAffixSetting(MonitoringDeprecatedSettings.PIPELINE_CHECK_TIMEOUT_SETTING, "Remove the following settings: [%s]", "https://ela.st/es-deprecation-7-monitoring-exporter-pipeline-timeout-setting", DeprecationIssue.Level.WARNING, clusterState.metadata().settings(), settings);
    }

    static DeprecationIssue checkExporterCreateLegacyTemplateSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        return NodeDeprecationChecks.deprecatedAffixSetting(MonitoringDeprecatedSettings.TEMPLATE_CREATE_LEGACY_VERSIONS_SETTING, "Remove the following settings: [%s]", "https://ela.st/es-deprecation-7-monitoring-exporter-create-legacy-template-setting", DeprecationIssue.Level.WARNING, clusterState.metadata().settings(), settings);
    }

    static DeprecationIssue checkScriptContextCache(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        if (ScriptService.isUseContextCacheSet((Settings)settings)) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, ScriptService.USE_CONTEXT_RATE_KEY_DEPRECATION_MESSAGE, "https://ela.st/es-deprecation-7-script-context-cache", "found deprecated script context caches in use, change setting to compilation rate or remove setting to use the default", false, null);
        }
        return null;
    }

    static DeprecationIssue checkScriptContextCompilationsRateLimitSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting.AffixSetting maxSetting = ScriptService.SCRIPT_MAX_COMPILATIONS_RATE_SETTING;
        Set contextCompilationRates = maxSetting.getAsMap(settings).keySet();
        if (ScriptService.isImplicitContextCacheSet((Settings)settings)) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, ScriptService.contextDeprecationMessage((Settings)settings), "https://ela.st/es-deprecation-7-script-context-cache", "Remove the context-specific cache settings and set [script.max_compilations_rate] to configure the rate limit for the general cache. If no limit is set, the rate defaults to 150 compilations per five minutes: 150/5m. Context-specific caches are no longer needed to prevent system scripts from triggering rate limits.", false, null);
        }
        if (!contextCompilationRates.isEmpty()) {
            String maxSettings = contextCompilationRates.stream().sorted().map(c -> maxSetting.getConcreteSettingForNamespace(c).getKey()).collect(Collectors.joining(","));
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, String.format(Locale.ROOT, "Setting context-specific rate limits [%s] is deprecated. Use [%s] to rate limit the compilation of user scripts. Context-specific caches are no longer needed to prevent system scripts from triggering rate limits.", maxSettings, ScriptService.SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.getKey()), "https://ela.st/es-deprecation-7-script-context-cache", String.format(Locale.ROOT, "[%s] is deprecated and will be removed in a future release", maxSettings), false, null);
        }
        return null;
    }

    static DeprecationIssue checkScriptContextCacheSizeSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting.AffixSetting cacheSizeSetting = ScriptService.SCRIPT_CACHE_SIZE_SETTING;
        Set contextCacheSizes = cacheSizeSetting.getAsMap(settings).keySet();
        if (!contextCacheSizes.isEmpty()) {
            String cacheSizeSettings = contextCacheSizes.stream().sorted().map(c -> cacheSizeSetting.getConcreteSettingForNamespace(c).getKey()).collect(Collectors.joining(","));
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, String.format(Locale.ROOT, "Setting a context-specific cache size [%s] is deprecated. Use [%s] to configure the size of the general cache for scripts. Context-specific caches are no longer needed to prevent system scripts from triggering rate limits.", cacheSizeSettings, ScriptService.SCRIPT_GENERAL_CACHE_SIZE_SETTING.getKey()), "https://ela.st/es-deprecation-7-script-context-cache", String.format(Locale.ROOT, "[%s] is deprecated and will be removed in a future release", cacheSizeSettings), false, null);
        }
        return null;
    }

    static DeprecationIssue checkScriptContextCacheExpirationSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting.AffixSetting cacheExpireSetting = ScriptService.SCRIPT_CACHE_EXPIRE_SETTING;
        Set contextCacheExpires = cacheExpireSetting.getAsMap(settings).keySet();
        if (!contextCacheExpires.isEmpty()) {
            String cacheExpireSettings = contextCacheExpires.stream().sorted().map(c -> cacheExpireSetting.getConcreteSettingForNamespace(c).getKey()).collect(Collectors.joining(","));
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, String.format(Locale.ROOT, "Setting a context-specific cache expiration [%s] is deprecated. Use [%s] to configure the expiration of the general cache. Context-specific caches are no longer needed to prevent system scripts from triggering rate limits.", cacheExpireSettings, ScriptService.SCRIPT_GENERAL_CACHE_EXPIRE_SETTING.getKey()), "https://ela.st/es-deprecation-7-script-context-cache", String.format(Locale.ROOT, "[%s] is deprecated and will be removed in a future release", cacheExpireSettings), false, null);
        }
        return null;
    }

    static DeprecationIssue checkEnforceDefaultTierPreferenceSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        if (DataTier.ENFORCE_DEFAULT_TIER_PREFERENCE_SETTING.exists(settings)) {
            String key = DataTier.ENFORCE_DEFAULT_TIER_PREFERENCE_SETTING.getKey();
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, String.format(Locale.ROOT, "setting [%s] is deprecated and will not be available in a future version", key), "https://www.elastic.co/guide/en/elasticsearch/reference/current/data-tiers.html", String.format(Locale.ROOT, "found [%s] configured. Discontinue use of this setting.", key), false, null);
        }
        return null;
    }

    static DeprecationIssue checkLifecyleStepMasterTimeoutSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = LifecycleSettings.LIFECYCLE_STEP_MASTER_TIMEOUT_SETTING;
        String url = "https://ela.st/es-deprecation-8-lifecycle-master-timeout-setting";
        return NodeDeprecationChecks.checkRemovedSetting(clusterState.metadata().settings(), settings, deprecatedSetting, url, "As of 7.16 the timeout is always infinite.", DeprecationIssue.Level.WARNING);
    }

    static DeprecationIssue checkEqlEnabledSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = Setting.boolSetting((String)"xpack.eql.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.DeprecatedWarning});
        String url = "https://ela.st/es-deprecation-8-eql-enabled-setting";
        return NodeDeprecationChecks.checkRemovedSetting(clusterState.metadata().settings(), settings, deprecatedSetting, url, "As of 7.9.2 basic license level features are always enabled.", DeprecationIssue.Level.WARNING);
    }

    static DeprecationIssue checkNodeAttrData(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        String nodeAttrDataValue = settings.get("node.attr.data");
        if (nodeAttrDataValue == null) {
            return null;
        }
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Setting node.attributes.data is not recommended", "https://ela.st/es-deprecation-7-node-attr-data-setting", "One or more of your nodes is configured with node.attributes.data settings. This is typically used to create a hot/warm or tiered architecture, based on legacy guidelines. Data tiers are a recommended replacement for tiered architecture clusters.", false, null);
    }

    static DeprecationIssue checkWatcherBulkConcurrentRequestsSetting(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        Setting deprecatedSetting = Setting.intSetting((String)"xpack.watcher.bulk.concurrent_requests", (int)0, (int)0, (int)20, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
        String url = "https://ela.st/es-deprecation-8-watcher-bulk-concurrency-setting";
        return NodeDeprecationChecks.checkRemovedSetting(clusterState.metadata().settings(), settings, deprecatedSetting, url, "As of 8.8.0 this setting is ignored.", DeprecationIssue.Level.WARNING);
    }

    static DeprecationIssue checkTracingApmSettings(Settings settings, PluginsAndModules pluginsAndModules, ClusterState clusterState, XPackLicenseState licenseState) {
        String url = "https://ela.st/es-deprecation-9-tracing-apm-settings";
        Setting.Property[] properties = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.OperatorDynamic, Setting.Property.Deprecated};
        List<Setting<?>> tracingApmSettings = List.of(Setting.prefixKeySetting((String)"tracing.apm.agent.", key -> Setting.simpleString((String)key, (Setting.Property[])properties)), Setting.stringListSetting((String)"tracing.apm.names.include", (Setting.Property[])properties), Setting.stringListSetting((String)"tracing.apm.names.exclude", (Setting.Property[])properties), Setting.stringListSetting((String)"tracing.apm.sanitize_field_names", (Setting.Property[])properties), Setting.boolSetting((String)"tracing.apm.enabled", (boolean)false, (Setting.Property[])properties), SecureSetting.secureString((String)"tracing.apm.api_key", null, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}), SecureSetting.secureString((String)"tracing.apm.secret_token", null, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated}));
        return NodeDeprecationChecks.checkMultipleRemovedSettings(clusterState.metadata().settings(), settings, tracingApmSettings, url, "[tracing.apm.*] settings are no longer accepted as of 9.0.0 and should be replaced by [telemetry.*] or [telemetry.tracing.*] settings.", DeprecationIssue.Level.CRITICAL);
    }

    @FunctionalInterface
    public static interface NodeDeprecationCheck<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }
}

