/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.tree;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Location;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;

public abstract class Node<T extends Node<T>>
implements NamedWriteable {
    private static final int TO_STRING_MAX_PROP = 10;
    private static final int TO_STRING_MAX_WIDTH = 110;
    private final Source source;
    private final List<T> children;

    public Node(Source source, List<T> children) {
        Source source2 = this.source = source != null ? source : Source.EMPTY;
        if (this.containsNull(children)) {
            throw new QlIllegalArgumentException("Null children are not allowed");
        }
        this.children = children;
    }

    public Source source() {
        return this.source;
    }

    public Location sourceLocation() {
        return this.source.source();
    }

    public String sourceText() {
        return this.source.text();
    }

    public List<T> children() {
        return this.children;
    }

    public void forEachDown(Consumer<? super T> action) {
        action.accept(this);
        this.children().forEach(c -> c.forEachDown(action));
    }

    public <E extends T> void forEachDown(Class<E> typeToken, Consumer<? super E> action) {
        this.forEachDown(t -> {
            if (typeToken.isInstance(t)) {
                action.accept((Object)t);
            }
        });
    }

    public void forEachUp(Consumer<? super T> action) {
        this.children().forEach(c -> c.forEachUp(action));
        action.accept(this);
    }

    public <E extends T> void forEachUp(Class<E> typeToken, Consumer<? super E> action) {
        this.forEachUp(t -> {
            if (typeToken.isInstance(t)) {
                action.accept((Object)t);
            }
        });
    }

    public <E> void forEachPropertyOnly(Class<E> typeToken, Consumer<? super E> rule) {
        this.forEachProperty(typeToken, rule);
    }

    public <E> void forEachPropertyDown(Class<E> typeToken, Consumer<? super E> rule) {
        this.forEachDown(e -> e.forEachProperty(typeToken, rule));
    }

    public <E> void forEachPropertyUp(Class<E> typeToken, Consumer<? super E> rule) {
        this.forEachUp(e -> e.forEachProperty(typeToken, rule));
    }

    protected <E> void forEachProperty(Class<E> typeToken, Consumer<? super E> rule) {
        for (Object prop : this.info().properties()) {
            if (prop == this.children || !typeToken.isInstance(prop) || this.children.contains(prop)) continue;
            rule.accept(prop);
        }
    }

    public boolean anyMatch(Predicate<? super T> predicate) {
        boolean result = predicate.test(this);
        if (!result) {
            for (Node child : this.children) {
                if (!child.anyMatch(predicate)) continue;
                return true;
            }
        }
        return result;
    }

    public List<T> collect(Predicate<? super T> predicate) {
        ArrayList l = new ArrayList();
        this.forEachDown(n -> {
            if (predicate.test(n)) {
                l.add(n);
            }
        });
        return l.isEmpty() ? Collections.emptyList() : l;
    }

    public List<T> collectLeaves() {
        return this.collect(n -> n.children().isEmpty());
    }

    public List<T> collectFirstChildren(Predicate<? super T> predicate) {
        ArrayList matches = new ArrayList();
        this.doCollectFirst(predicate, matches);
        return matches;
    }

    protected void doCollectFirst(Predicate<? super T> predicate, List<T> matches) {
        Node t = this;
        if (predicate.test(t)) {
            matches.add(t);
        } else {
            for (Node child : this.children()) {
                child.doCollectFirst(predicate, matches);
            }
        }
    }

    public T transformDown(Function<? super T, ? extends T> rule) {
        Node root = (Node)rule.apply(this);
        Node node = this.equals(root) ? this : root;
        return (T)node.transformChildren(child -> child.transformDown(rule));
    }

    public <E extends T> T transformDown(Class<E> typeToken, Function<E, ? extends T> rule) {
        return (T)this.transformDown(t -> typeToken.isInstance(t) ? (Node)rule.apply(t) : t);
    }

    public T transformUp(Function<? super T, ? extends T> rule) {
        Node transformed = this.transformChildren(child -> child.transformUp(rule));
        Node node = this.equals(transformed) ? this : transformed;
        return (T)((Node)rule.apply(node));
    }

    public <E extends T> T transformUp(Class<E> typeToken, Function<E, ? extends T> rule) {
        return (T)this.transformUp(t -> typeToken.isInstance(t) ? (Node)rule.apply(t) : t);
    }

    protected <R extends Function<? super T, ? extends T>> T transformChildren(Function<T, ? extends T> traversalOperation) {
        boolean childrenChanged = false;
        ArrayList<T> transformedChildren = null;
        int s = this.children.size();
        for (int i = 0; i < s; ++i) {
            Node next;
            Node child = (Node)this.children.get(i);
            if (child.equals(next = (Node)traversalOperation.apply(child))) continue;
            if (!childrenChanged) {
                childrenChanged = true;
                transformedChildren = new ArrayList<T>(this.children);
            }
            transformedChildren.set(i, next);
        }
        return (T)(childrenChanged ? this.replaceChildrenSameSize(transformedChildren) : this);
    }

    public final T replaceChildrenSameSize(List<T> newChildren) {
        if (newChildren.size() != this.children.size()) {
            throw new QlIllegalArgumentException("Expected the same number of children [" + this.children.size() + "], but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren);
    }

    public abstract T replaceChildren(List<T> var1);

    public <E> T transformPropertiesOnly(Class<E> typeToken, Function<? super E, ? extends E> rule) {
        return this.transformNodeProps(typeToken, rule);
    }

    public <E> T transformPropertiesDown(Class<E> typeToken, Function<? super E, ? extends E> rule) {
        return (T)this.transformDown(t -> t.transformNodeProps(typeToken, rule));
    }

    public <E> T transformPropertiesUp(Class<E> typeToken, Function<? super E, ? extends E> rule) {
        return (T)this.transformUp(t -> t.transformNodeProps(typeToken, rule));
    }

    protected final <E> T transformNodeProps(Class<E> typeToken, Function<? super E, ? extends E> rule) {
        return this.info().transform(rule, typeToken);
    }

    protected abstract NodeInfo<? extends T> info();

    public int hashCode() {
        return Objects.hash(this.children);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.children(), other.children());
    }

    public String nodeName() {
        return this.getClass().getSimpleName();
    }

    public List<Object> nodeProperties() {
        return this.info().properties();
    }

    public String nodeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nodeName());
        sb.append("[");
        sb.append(this.propertiesToString(true));
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return this.treeString(new StringBuilder(), 0, new BitSet()).toString();
    }

    final StringBuilder treeString(StringBuilder sb, int depth, BitSet hasParentPerDepth) {
        if (depth > 0) {
            for (int column = 0; column < depth; ++column) {
                if (hasParentPerDepth.get(column)) {
                    sb.append("|");
                    if (column >= depth - 1) continue;
                    sb.append(" ");
                    continue;
                }
                sb.append(column == depth - 1 ? "\\" : "  ");
            }
            sb.append("_");
        }
        sb.append(this.nodeString());
        List<T> children = this.children();
        if (!children.isEmpty()) {
            sb.append("\n");
        }
        for (int i = 0; i < children.size(); ++i) {
            Node t = (Node)children.get(i);
            hasParentPerDepth.set(depth, i < children.size() - 1);
            t.treeString(sb, depth + 1, hasParentPerDepth);
            if (i >= children.size() - 1) continue;
            sb.append("\n");
        }
        return sb;
    }

    public String propertiesToString(boolean skipIfChild) {
        StringBuilder sb = new StringBuilder();
        List<T> children = this.children();
        int remainingProperties = 10;
        int maxWidth = 0;
        boolean needsComma = false;
        List<Object> props = this.nodeProperties();
        for (Object prop : props) {
            String stringValue;
            if (skipIfChild && (children.contains(prop) || children.equals(prop))) continue;
            if (remainingProperties-- < 0) {
                sb.append("...").append(props.size() - 10).append("fields not shown");
                break;
            }
            if (needsComma) {
                sb.append(",");
            }
            if (maxWidth + (stringValue = Node.toString(prop)).length() > 110) {
                int cutoff = Math.max(0, 110 - maxWidth);
                sb.append(stringValue.substring(0, cutoff));
                sb.append("\n");
                stringValue = stringValue.substring(cutoff);
                maxWidth = 0;
            }
            maxWidth += stringValue.length();
            sb.append(stringValue);
            needsComma = true;
        }
        return sb.toString();
    }

    private static String toString(Object obj) {
        StringBuilder sb = new StringBuilder();
        Node.toString(sb, obj);
        return sb.toString();
    }

    private static void toString(StringBuilder sb, Object obj) {
        if (obj instanceof Iterable) {
            sb.append("[");
            Iterator it = ((Iterable)obj).iterator();
            while (it.hasNext()) {
                Object o = it.next();
                Node.toString(sb, o);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
        } else if (obj instanceof Node) {
            sb.append(((Node)obj).nodeString());
        } else {
            sb.append(Objects.toString(obj));
        }
    }

    private <U> boolean containsNull(List<U> us) {
        for (U u : us) {
            if (u != null) continue;
            return true;
        }
        return false;
    }
}

