/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.enrich.EnrichProcessorFactory;

public abstract class AbstractEnrichProcessor
extends AbstractProcessor {
    private final String policyName;
    private final EnrichProcessorFactory.SearchRunner searchRunner;
    private final TemplateScript.Factory field;
    private final TemplateScript.Factory targetField;
    private final boolean ignoreMissing;
    private final boolean overrideEnabled;
    protected final String matchField;
    protected final int maxMatches;
    private final String indexAlias;

    protected AbstractEnrichProcessor(String tag, String description, EnrichProcessorFactory.SearchRunner searchRunner, String policyName, TemplateScript.Factory field, TemplateScript.Factory targetField, boolean ignoreMissing, boolean overrideEnabled, String matchField, int maxMatches) {
        super(tag, description);
        this.policyName = policyName;
        this.searchRunner = searchRunner;
        this.field = field;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
        this.overrideEnabled = overrideEnabled;
        this.matchField = matchField;
        this.maxMatches = maxMatches;
        this.indexAlias = EnrichPolicy.getBaseName((String)policyName);
    }

    public abstract QueryBuilder getQueryBuilder(Object var1);

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        try {
            String renderedField = ingestDocument.renderTemplate(this.field);
            Object value = ingestDocument.getFieldValue(renderedField, Object.class, this.ignoreMissing);
            if (value == null) {
                handler.accept(ingestDocument, null);
                return;
            }
            Supplier<SearchRequest> searchRequestSupplier = () -> {
                QueryBuilder queryBuilder = this.getQueryBuilder(value);
                ConstantScoreQueryBuilder constantScore = new ConstantScoreQueryBuilder(queryBuilder);
                SearchSourceBuilder searchBuilder = new SearchSourceBuilder();
                searchBuilder.from(0);
                searchBuilder.size(this.maxMatches);
                searchBuilder.trackScores(false);
                searchBuilder.fetchSource(true);
                searchBuilder.query((QueryBuilder)constantScore);
                SearchRequest req = new SearchRequest();
                req.indices(new String[]{this.indexAlias});
                req.preference(Preference.LOCAL.type());
                req.source(searchBuilder);
                return req;
            };
            this.searchRunner.accept(value, this.maxMatches, searchRequestSupplier, (searchHits, e) -> {
                if (e != null) {
                    handler.accept((IngestDocument)null, (Exception)e);
                    return;
                }
                if (searchHits.isEmpty()) {
                    handler.accept(ingestDocument, null);
                    return;
                }
                String renderedTargetField = ingestDocument.renderTemplate(this.targetField);
                if (this.overrideEnabled || !ingestDocument.hasField(renderedTargetField)) {
                    if (this.maxMatches == 1) {
                        Map firstDocument = (Map)searchHits.get(0);
                        ingestDocument.setFieldValue(renderedTargetField, (Object)firstDocument);
                    } else {
                        ArrayList enrichDocuments = new ArrayList(searchHits.size());
                        enrichDocuments.addAll(searchHits);
                        ingestDocument.setFieldValue(renderedTargetField, enrichDocuments);
                    }
                }
                handler.accept(ingestDocument, null);
            });
        }
        catch (Exception e2) {
            handler.accept(null, e2);
        }
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException("this method should not get executed");
    }

    public boolean isAsync() {
        return true;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getType() {
        return "enrich";
    }

    String getField() {
        return this.field.newInstance(Map.of()).execute();
    }

    String getTargetField() {
        return this.targetField.newInstance(Map.of()).execute();
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    boolean isOverrideEnabled() {
        return this.overrideEnabled;
    }

    public String getMatchField() {
        return this.matchField;
    }

    int getMaxMatches() {
        return this.maxMatches;
    }
}

