/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.downsampling;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexSettings;

public class DeleteSourceAndAddDownsampleToDS
implements ClusterStateTaskListener {
    private static final Logger LOGGER = LogManager.getLogger(DeleteSourceAndAddDownsampleToDS.class);
    private final Settings settings;
    private ActionListener<Void> listener;
    private final String dataStreamName;
    private final String sourceBackingIndex;
    private final String downsampleIndex;

    public DeleteSourceAndAddDownsampleToDS(Settings settings, String dataStreamName, String sourceBackingIndex, String downsampleIndex, ActionListener<Void> listener) {
        this.settings = settings;
        this.dataStreamName = dataStreamName;
        this.sourceBackingIndex = sourceBackingIndex;
        this.downsampleIndex = downsampleIndex;
        this.listener = listener;
    }

    ClusterState execute(ClusterState state) {
        LOGGER.trace("Updating cluster state to replace and delete index [{}] with [{}] in data stream [{}]", (Object)this.sourceBackingIndex, (Object)this.downsampleIndex, (Object)this.dataStreamName);
        IndexMetadata downsampleIndexMeta = state.metadata().index(this.downsampleIndex);
        if (downsampleIndexMeta == null) {
            LOGGER.trace("Received request to replace index [{}] with [{}] in data stream [{}] but the replacement index [{}] doesn't exist.Nothing to do here.", (Object)this.sourceBackingIndex, (Object)this.downsampleIndex, (Object)this.dataStreamName, (Object)this.downsampleIndex);
            return state;
        }
        IndexAbstraction sourceIndexAbstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(this.sourceBackingIndex);
        if (sourceIndexAbstraction == null) {
            DataStream dataStream = (DataStream)state.metadata().dataStreams().get(this.dataStreamName);
            if (dataStream != null && dataStream.getIndices().stream().filter(index -> index.getName().equals(this.downsampleIndex)).findAny().isEmpty()) {
                LOGGER.trace("unable find source index [{}] but adding index [{}] to data stream [{}]", (Object)this.sourceBackingIndex, (Object)this.downsampleIndex, (Object)this.dataStreamName);
                Metadata.Builder newMetaData = Metadata.builder((Metadata)state.metadata()).put(dataStream.addBackingIndex(state.metadata(), downsampleIndexMeta.getIndex()));
                return ClusterState.builder((ClusterState)state).metadata(newMetaData).build();
            }
        } else {
            DataStream sourceParentDataStream = sourceIndexAbstraction.getParentDataStream();
            if (sourceParentDataStream != null && sourceParentDataStream.getWriteIndex().getName().equals(this.sourceBackingIndex)) {
                String errorMessage = String.format(Locale.ROOT, "index [%s] is the write index for data stream [%s] and cannot be replaced", this.sourceBackingIndex, sourceParentDataStream.getName());
                throw new IllegalStateException(errorMessage);
            }
            IndexMetadata sourceIndexMeta = state.metadata().index(this.sourceBackingIndex);
            assert (sourceIndexMeta != null) : "the source index abstraction exists in the indices lookup, so the index metadata must exist in the same cluster state metadata";
            state = MetadataDeleteIndexService.deleteIndices((ClusterState)state, Set.of(sourceIndexMeta.getIndex()), (Settings)this.settings);
            DataStream dataStream = (DataStream)state.metadata().dataStreams().get(this.dataStreamName);
            if (sourceParentDataStream != null) {
                assert (sourceParentDataStream.getName().equals(this.dataStreamName)) : "the backing index must be part of the provided data stream [" + this.dataStreamName + "] but it is instead part of data stream [" + sourceParentDataStream.getName() + "]";
                return DeleteSourceAndAddDownsampleToDS.addDownsampleIndexToDataStream(state, dataStream, sourceIndexMeta, downsampleIndexMeta);
            }
            if (dataStream != null && dataStream.getIndices().stream().filter(index -> index.getName().equals(this.downsampleIndex)).findAny().isEmpty()) {
                return DeleteSourceAndAddDownsampleToDS.addDownsampleIndexToDataStream(state, dataStream, sourceIndexMeta, downsampleIndexMeta);
            }
        }
        return state;
    }

    private static ClusterState addDownsampleIndexToDataStream(ClusterState state, DataStream dataStream, IndexMetadata sourceIndexMeta, IndexMetadata downsampleIndexMeta) {
        Metadata.Builder newMetaData = Metadata.builder((Metadata)state.getMetadata());
        TimeValue generationLifecycleDate = dataStream.getGenerationLifecycleDate(sourceIndexMeta);
        assert (generationLifecycleDate != null) : "write index must never be downsampled, or replaced";
        IndexMetadata updatedDownsampleMetadata = DeleteSourceAndAddDownsampleToDS.copyDataStreamLifecycleState(sourceIndexMeta, downsampleIndexMeta, generationLifecycleDate.millis());
        newMetaData.put(updatedDownsampleMetadata, true);
        newMetaData.put(dataStream.addBackingIndex(state.metadata(), downsampleIndexMeta.getIndex()));
        return ClusterState.builder((ClusterState)state).metadata(newMetaData).build();
    }

    private static IndexMetadata copyDataStreamLifecycleState(IndexMetadata source, IndexMetadata dest, long sourceIndexGenerationTimeMillis) {
        IndexMetadata.Builder downsampleIndexBuilder = IndexMetadata.builder((IndexMetadata)dest);
        Map lifecycleCustomMetadata = source.getCustomData("data_stream_lifecycle");
        if (lifecycleCustomMetadata != null) {
            downsampleIndexBuilder.putCustom("data_stream_lifecycle", lifecycleCustomMetadata);
        }
        if (!IndexSettings.LIFECYCLE_ORIGINATION_DATE_SETTING.exists(dest.getSettings())) {
            downsampleIndexBuilder.settings(Settings.builder().put(dest.getSettings()).put("index.lifecycle.origination_date", sourceIndexGenerationTimeMillis).build()).settingsVersion(dest.getSettingsVersion() + 1L);
        }
        return downsampleIndexBuilder.build();
    }

    public void onFailure(Exception e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }

    public String getDataStreamName() {
        return this.dataStreamName;
    }

    public String getSourceBackingIndex() {
        return this.sourceBackingIndex;
    }

    public String getDownsampleIndex() {
        return this.downsampleIndex;
    }

    public ActionListener<Void> getListener() {
        return this.listener;
    }

    public void setListener(ActionListener<Void> listener) {
        this.listener = listener;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteSourceAndAddDownsampleToDS that = (DeleteSourceAndAddDownsampleToDS)o;
        return Objects.equals(this.dataStreamName, that.dataStreamName) && Objects.equals(this.sourceBackingIndex, that.sourceBackingIndex) && Objects.equals(this.downsampleIndex, that.downsampleIndex);
    }

    public int hashCode() {
        return Objects.hash(this.dataStreamName, this.sourceBackingIndex, this.downsampleIndex);
    }
}

