/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.GetWatcherSettingsAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.UpdateWatcherSettingsAction;
import org.elasticsearch.xpack.watcher.transport.actions.TransportUpdateWatcherSettingsAction;

public class TransportGetWatcherSettingsAction
extends TransportMasterNodeAction<GetWatcherSettingsAction.Request, GetWatcherSettingsAction.Response> {
    @Inject
    public TransportGetWatcherSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/watcher/settings/get", transportService, clusterService, threadPool, actionFilters, GetWatcherSettingsAction.Request::readFrom, indexNameExpressionResolver, GetWatcherSettingsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, GetWatcherSettingsAction.Request request, ClusterState state, ActionListener<GetWatcherSettingsAction.Response> listener) {
        IndexMetadata metadata = state.metadata().index(".watches");
        if (metadata == null) {
            listener.onResponse((Object)new GetWatcherSettingsAction.Response(Settings.EMPTY));
        } else {
            listener.onResponse((Object)new GetWatcherSettingsAction.Response(TransportGetWatcherSettingsAction.filterSettableSettings(metadata.getSettings())));
        }
    }

    private static Settings filterSettableSettings(Settings settings) {
        Settings.Builder builder = Settings.builder();
        settings.keySet().stream().filter(setting -> (UpdateWatcherSettingsAction.ALLOWED_SETTING_KEYS.contains(setting) || UpdateWatcherSettingsAction.ALLOWED_SETTINGS_PREFIXES.stream().anyMatch(prefix -> setting.startsWith(prefix + "."))) && !UpdateWatcherSettingsAction.EXPLICITLY_DENIED_SETTINGS.contains(setting)).forEach(setting -> builder.put(setting, settings.get(setting)));
        return builder.build();
    }

    protected ClusterBlockException checkBlock(GetWatcherSettingsAction.Request request, ClusterState state) {
        ClusterBlockException globalBlock = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        if (globalBlock != null) {
            return globalBlock;
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(state, TransportUpdateWatcherSettingsAction.WATCHER_INDEX_REQUEST));
    }
}

