/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.slack.message;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.watcher.common.text.TextTemplate;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.slack.message.MessageElement;

public class Action
implements MessageElement {
    static final ObjectParser<Template, Void> ACTION_PARSER = new ObjectParser("action", Template::new);
    private static final ParseField URL;
    private static final ParseField TYPE;
    private static final ParseField TEXT;
    private static final ParseField STYLE;
    private static final ParseField NAME;
    private String style;
    private String name;
    private String type;
    private String text;
    private String url;

    public Action() {
    }

    public Action(String style, String name, String type, String text, String url) {
        this.style = style;
        this.name = name;
        this.type = type;
        this.text = text;
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action template = (Action)o;
        return Objects.equals(this.style, template.style) && Objects.equals(this.type, template.type) && Objects.equals(this.url, template.url) && Objects.equals(this.text, template.text) && Objects.equals(this.name, template.name);
    }

    public int hashCode() {
        return Objects.hash(this.style, this.type, this.url, this.name, this.text);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(NAME.getPreferredName(), this.name).field(STYLE.getPreferredName(), this.style).field(TYPE.getPreferredName(), this.type).field(TEXT.getPreferredName(), this.text).field(URL.getPreferredName(), this.url).endObject();
    }

    static {
        ACTION_PARSER.declareField(Template::setType, (p, c) -> new TextTemplate(p.text()), new ParseField("type", new String[0]), ObjectParser.ValueType.STRING);
        ACTION_PARSER.declareField(Template::setUrl, (p, c) -> new TextTemplate(p.text()), new ParseField("url", new String[0]), ObjectParser.ValueType.STRING);
        ACTION_PARSER.declareField(Template::setText, (p, c) -> new TextTemplate(p.text()), new ParseField("text", new String[0]), ObjectParser.ValueType.STRING);
        ACTION_PARSER.declareField(Template::setStyle, (p, c) -> new TextTemplate(p.text()), new ParseField("style", new String[0]), ObjectParser.ValueType.STRING);
        ACTION_PARSER.declareField(Template::setName, (p, c) -> new TextTemplate(p.text()), new ParseField("name", new String[0]), ObjectParser.ValueType.STRING);
        URL = new ParseField("url", new String[0]);
        TYPE = new ParseField("type", new String[0]);
        TEXT = new ParseField("text", new String[0]);
        STYLE = new ParseField("style", new String[0]);
        NAME = new ParseField("name", new String[0]);
    }

    static class Template
    implements ToXContent {
        private TextTemplate type;
        private TextTemplate name;
        private TextTemplate text;
        private TextTemplate url;
        private TextTemplate style;

        Template() {
        }

        public Action render(TextTemplateEngine engine, Map<String, Object> model) {
            String style = engine.render(this.style, model);
            String type = engine.render(this.type, model);
            String url = engine.render(this.url, model);
            String name = engine.render(this.name, model);
            String text = engine.render(this.text, model);
            return new Action(style, name, type, text, url);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            return Objects.equals(this.style, template.style) && Objects.equals(this.type, template.type) && Objects.equals(this.url, template.url) && Objects.equals(this.text, template.text) && Objects.equals(this.name, template.name);
        }

        public int hashCode() {
            return Objects.hash(this.style, this.type, this.url, this.name, this.text);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(NAME.getPreferredName(), (ToXContent)this.name).field(STYLE.getPreferredName(), (ToXContent)this.style).field(TYPE.getPreferredName(), (ToXContent)this.type).field(TEXT.getPreferredName(), (ToXContent)this.text).field(URL.getPreferredName(), (ToXContent)this.url).endObject();
        }

        public TextTemplate getType() {
            return this.type;
        }

        public void setType(TextTemplate type) {
            this.type = type;
        }

        public TextTemplate getName() {
            return this.name;
        }

        public void setName(TextTemplate name) {
            this.name = name;
        }

        public TextTemplate getText() {
            return this.text;
        }

        public void setText(TextTemplate text) {
            this.text = text;
        }

        public TextTemplate getUrl() {
            return this.url;
        }

        public void setUrl(TextTemplate url) {
            this.url = url;
        }

        public TextTemplate getStyle() {
            return this.style;
        }

        public void setStyle(TextTemplate style) {
            this.style = style;
        }
    }
}

