/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.watcher.WatcherFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.WatcherField;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsResponse;

public class WatcherUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    private final Client client;

    @Inject
    public WatcherUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Settings settings, XPackLicenseState licenseState, Client client) {
        super(XPackUsageFeatureAction.WATCHER.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.enabled = (Boolean)XPackSettings.WATCHER_ENABLED.get(settings);
        this.licenseState = licenseState;
        this.client = client;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        if (this.enabled) {
            ContextPreservingActionListener preservingListener = ContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)this.client.threadPool().getThreadContext());
            try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("watcher");){
                WatcherStatsRequest statsRequest = new WatcherStatsRequest();
                statsRequest.includeStats(true);
                statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
                this.client.execute((ActionType)WatcherStatsAction.INSTANCE, (ActionRequest)statsRequest, ActionListener.wrap(arg_0 -> this.lambda$masterOperation$0((ActionListener)preservingListener, arg_0), arg_0 -> ((ActionListener)preservingListener).onFailure(arg_0)));
            }
        } else {
            WatcherFeatureSetUsage usage = new WatcherFeatureSetUsage(WatcherField.WATCHER_FEATURE.checkWithoutTracking(this.licenseState), false, Collections.emptyMap());
            listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)usage));
        }
    }

    private /* synthetic */ void lambda$masterOperation$0(ActionListener preservingListener, WatcherStatsResponse r) throws Exception {
        List<Counters> countersPerNode = r.getNodes().stream().map(WatcherStatsResponse.Node::getStats).filter(Objects::nonNull).toList();
        Counters mergedCounters = Counters.merge(countersPerNode);
        WatcherFeatureSetUsage usage = new WatcherFeatureSetUsage(WatcherField.WATCHER_FEATURE.checkWithoutTracking(this.licenseState), true, mergedCounters.toNestedMap());
        preservingListener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)usage));
    }
}

