/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.plan.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.NodeUtils;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.EsField;

public class EsRelation
extends LeafPlan {
    private final EsIndex index;
    private final List<Attribute> attrs;
    private final boolean frozen;

    public EsRelation(Source source, EsIndex index, boolean frozen) {
        this(source, index, EsRelation.flatten(source, index.mapping()), frozen);
    }

    public EsRelation(Source source, EsIndex index, List<Attribute> attributes) {
        this(source, index, attributes, false);
    }

    public EsRelation(Source source, EsIndex index, List<Attribute> attributes, boolean frozen) {
        super(source);
        this.index = index;
        this.attrs = attributes;
        this.frozen = frozen;
    }

    @Override
    protected NodeInfo<EsRelation> info() {
        return NodeInfo.create(this, EsRelation::new, this.index, this.attrs, this.frozen);
    }

    private static List<Attribute> flatten(Source source, Map<String, EsField> mapping) {
        return EsRelation.flatten(source, mapping, null);
    }

    private static List<Attribute> flatten(Source source, Map<String, EsField> mapping, FieldAttribute parent) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            String name = entry.getKey();
            EsField t = entry.getValue();
            if (t == null) continue;
            FieldAttribute f = new FieldAttribute(source, parent, (String)(parent != null ? parent.name() + "." + name : name), t);
            list.add(f);
            if (t.getProperties().isEmpty()) continue;
            list.addAll(EsRelation.flatten(source, t.getProperties(), f));
        }
        return list;
    }

    public EsIndex index() {
        return this.index;
    }

    public boolean frozen() {
        return this.frozen;
    }

    @Override
    public List<Attribute> output() {
        return this.attrs;
    }

    @Override
    public boolean expressionsResolved() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.frozen);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsRelation other = (EsRelation)obj;
        return Objects.equals(this.index, other.index) && this.frozen == other.frozen;
    }

    @Override
    public String nodeString() {
        return this.nodeName() + "[" + String.valueOf(this.index) + "]" + NodeUtils.limitedToString(this.attrs);
    }
}

