/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.util.Objects;
import org.elasticsearch.nativeaccess.CloseableByteBuffer;
import org.elasticsearch.nativeaccess.lib.ZstdLibrary;

public final class Zstd {
    private final ZstdLibrary zstdLib;

    Zstd(ZstdLibrary zstdLib) {
        this.zstdLib = zstdLib;
    }

    public int compress(CloseableByteBuffer dst, CloseableByteBuffer src, int level) {
        Objects.requireNonNull(dst, "Null destination buffer");
        Objects.requireNonNull(src, "Null source buffer");
        long ret = this.zstdLib.compress(dst, src, level);
        if (this.zstdLib.isError(ret)) {
            throw new IllegalArgumentException(this.zstdLib.getErrorName(ret));
        }
        if (ret < 0L || ret > Integer.MAX_VALUE) {
            throw new IllegalStateException("Integer overflow? ret=" + ret);
        }
        return (int)ret;
    }

    public int decompress(CloseableByteBuffer dst, CloseableByteBuffer src) {
        Objects.requireNonNull(dst, "Null destination buffer");
        Objects.requireNonNull(src, "Null source buffer");
        long ret = this.zstdLib.decompress(dst, src);
        if (this.zstdLib.isError(ret)) {
            throw new IllegalArgumentException(this.zstdLib.getErrorName(ret));
        }
        if (ret < 0L || ret > Integer.MAX_VALUE) {
            throw new IllegalStateException("Integer overflow? ret=" + ret);
        }
        return (int)ret;
    }

    public int compressBound(int srcLen) {
        long ret = this.zstdLib.compressBound(srcLen);
        if (this.zstdLib.isError(ret)) {
            throw new IllegalArgumentException(this.zstdLib.getErrorName(ret));
        }
        if (ret < 0L || ret > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(srcLen + " bytes may require up to " + Long.toUnsignedString(ret) + " bytes, which overflows the maximum capacity of a ByteBuffer");
        }
        return (int)ret;
    }
}

