/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalValueCount;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.aggregatemetric.aggregations.support.AggregateMetricsValuesSource;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateDoubleMetricFieldMapper;

class AggregateMetricBackedValueCountAggregator
extends NumericMetricsAggregator.SingleValue {
    private final AggregateMetricsValuesSource.AggregateDoubleMetric valuesSource;
    LongArray counts;

    AggregateMetricBackedValueCountAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, aggregationContext, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (AggregateMetricsValuesSource.AggregateDoubleMetric)valuesSourceConfig.getValuesSource();
        this.counts = this.bigArrays().newLongArray(1L, true);
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final BigArrays bigArrays = this.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.getAggregateMetricValues(aggCtx.getLeafReaderContext(), AggregateDoubleMetricFieldMapper.Metric.value_count);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                AggregateMetricBackedValueCountAggregator.this.counts = bigArrays.grow(AggregateMetricBackedValueCountAggregator.this.counts, bucket + 1L);
                if (values.advanceExact(doc)) {
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        long value = Double.valueOf(values.nextValue()).longValue();
                        AggregateMetricBackedValueCountAggregator.this.counts.increment(bucket, value);
                    }
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        return owningBucketOrd >= this.counts.size() ? 0.0 : (double)this.counts.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalValueCount(this.name, this.counts.get(bucket), this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return InternalValueCount.empty((String)this.name, (Map)this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable)this.counts);
    }
}

