/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldCollector;
import org.elasticsearch.common.Strings;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;

public final class LuceneTopNSourceOperator
extends LuceneOperator {
    private ScoreDoc[] scoreDocs;
    private int offset = 0;
    private PerShardCollector perShardCollector;
    private final List<SortBuilder<?>> sorts;
    private final int limit;

    public LuceneTopNSourceOperator(BlockFactory blockFactory, int maxPageSize, List<SortBuilder<?>> sorts, int limit, LuceneSliceQueue sliceQueue) {
        super(blockFactory, maxPageSize, sliceQueue);
        this.sorts = sorts;
        this.limit = limit;
    }

    @Override
    public boolean isFinished() {
        return this.doneCollecting && !this.isEmitting();
    }

    @Override
    public void finish() {
        this.doneCollecting = true;
        this.scoreDocs = null;
        assert (this.isFinished());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getCheckedOutput() throws IOException {
        if (this.isFinished()) {
            return null;
        }
        long start = System.nanoTime();
        try {
            if (this.isEmitting()) {
                Page page = this.emit(false);
                return page;
            }
            Page page = this.collect();
            return page;
        }
        finally {
            this.processingNanos += System.nanoTime() - start;
        }
    }

    private Page collect() throws IOException {
        LuceneOperator.LuceneScorer nextScorer;
        assert (!this.doneCollecting);
        LuceneOperator.LuceneScorer scorer = this.getCurrentOrLoadNextScorer();
        if (scorer == null) {
            this.doneCollecting = true;
            return this.emit(true);
        }
        try {
            if (this.perShardCollector == null || this.perShardCollector.shardContext.index() != scorer.shardContext().index()) {
                this.perShardCollector = new PerShardCollector(scorer.shardContext(), this.sorts, this.limit);
            }
            LeafCollector leafCollector = this.perShardCollector.getLeafCollector(scorer.leafReaderContext());
            scorer.scoreNextRange(leafCollector, scorer.leafReaderContext().reader().getLiveDocs(), this.maxPageSize);
        }
        catch (CollectionTerminatedException cte) {
            scorer.markAsDone();
        }
        if (scorer.isDone() && ((nextScorer = this.getCurrentOrLoadNextScorer()) == null || nextScorer.shardContext().index() != scorer.shardContext().index())) {
            return this.emit(true);
        }
        return null;
    }

    private boolean isEmitting() {
        return this.scoreDocs != null && this.offset < this.scoreDocs.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Page emit(boolean startEmitting) {
        Page page;
        block20: {
            if (startEmitting) {
                assert (!this.isEmitting()) : "offset=" + this.offset + " score_docs=" + Arrays.toString(this.scoreDocs);
                this.offset = 0;
                this.scoreDocs = this.perShardCollector != null ? this.perShardCollector.topFieldCollector.topDocs().scoreDocs : new ScoreDoc[0];
            }
            if (this.offset >= this.scoreDocs.length) {
                return null;
            }
            int size = Math.min(this.maxPageSize, this.scoreDocs.length - this.offset);
            IntBlock shard = null;
            IntVector segments = null;
            IntVector docs = null;
            page = null;
            try {
                try (IntVector.FixedBuilder currentSegmentBuilder = this.blockFactory.newIntVectorFixedBuilder(size);
                     IntVector.FixedBuilder currentDocsBuilder = this.blockFactory.newIntVectorFixedBuilder(size);){
                    int start = this.offset;
                    this.offset += size;
                    List leafContexts = this.perShardCollector.shardContext.searcher().getLeafContexts();
                    for (int i = start; i < this.offset; ++i) {
                        int doc = this.scoreDocs[i].doc;
                        int segment = ReaderUtil.subIndex((int)doc, (List)leafContexts);
                        currentSegmentBuilder.appendInt(segment);
                        currentDocsBuilder.appendInt(doc - ((LeafReaderContext)leafContexts.get((int)segment)).docBase);
                    }
                    shard = this.blockFactory.newConstantIntBlockWith(this.perShardCollector.shardContext.index(), size);
                    segments = currentSegmentBuilder.build();
                    docs = currentDocsBuilder.build();
                    page = new Page(size, new DocVector(shard.asVector(), segments, docs, null).asBlock());
                }
                if (page != null) break block20;
            }
            catch (Throwable throwable) {
                if (page == null) {
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, segments, docs});
                }
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, segments, docs});
        }
        ++this.pagesEmitted;
        return page;
    }

    @Override
    protected void describe(StringBuilder sb) {
        sb.append(", limit = ").append(this.limit);
        String notPrettySorts = this.sorts.stream().map(Strings::toString).collect(Collectors.joining(","));
        sb.append(", sorts = [").append(notPrettySorts).append("]");
    }

    static final class PerShardCollector {
        private final ShardContext shardContext;
        private final TopFieldCollector topFieldCollector;
        private int leafIndex;
        private LeafCollector leafCollector;
        private Thread currentThread;

        PerShardCollector(ShardContext shardContext, List<SortBuilder<?>> sorts, int limit) throws IOException {
            this.shardContext = shardContext;
            Optional<SortAndFormats> sortAndFormats = shardContext.buildSort(sorts);
            if (sortAndFormats.isEmpty()) {
                throw new IllegalStateException("sorts must not be disabled in TopN");
            }
            this.topFieldCollector = TopFieldCollector.create((Sort)sortAndFormats.get().sort, (int)limit, (int)0);
        }

        LeafCollector getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
            if (this.currentThread != Thread.currentThread() || this.leafIndex != leafReaderContext.ord) {
                this.leafCollector = this.topFieldCollector.getLeafCollector(leafReaderContext);
                this.leafIndex = leafReaderContext.ord;
                this.currentThread = Thread.currentThread();
            }
            return this.leafCollector;
        }
    }

    public static final class Factory
    extends LuceneOperator.Factory {
        private final int maxPageSize;
        private final List<SortBuilder<?>> sorts;

        public Factory(List<? extends ShardContext> contexts, Function<ShardContext, Query> queryFunction, DataPartitioning dataPartitioning, int taskConcurrency, int maxPageSize, int limit, List<SortBuilder<?>> sorts) {
            super(contexts, queryFunction, dataPartitioning, taskConcurrency, limit, ScoreMode.TOP_DOCS);
            this.maxPageSize = maxPageSize;
            this.sorts = sorts;
        }

        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new LuceneTopNSourceOperator(driverContext.blockFactory(), this.maxPageSize, this.sorts, this.limit, this.sliceQueue);
        }

        public int maxPageSize() {
            return this.maxPageSize;
        }

        @Override
        public String describe() {
            String notPrettySorts = this.sorts.stream().map(Strings::toString).collect(Collectors.joining(","));
            return "LuceneTopNSourceOperator[dataPartitioning = " + String.valueOf((Object)this.dataPartitioning) + ", maxPageSize = " + this.maxPageSize + ", limit = " + this.limit + ", sorts = [" + notPrettySorts + "]]";
        }
    }
}

