/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.compute.data.AbstractBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;

final class IntBlockBuilder
extends AbstractBlockBuilder
implements IntBlock.Builder {
    private int[] values;

    IntBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        int initialSize = Math.max(estimatedSize, 2);
        this.adjustBreaker(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + initialSize * this.elementSize());
        this.values = new int[initialSize];
    }

    @Override
    public IntBlockBuilder appendInt(int value) {
        this.ensureCapacity();
        this.values[this.valueCount] = value;
        this.hasNonNullValue = true;
        ++this.valueCount;
        this.updatePosition();
        return this;
    }

    @Override
    protected int elementSize() {
        return 4;
    }

    @Override
    protected int valuesLength() {
        return this.values.length;
    }

    @Override
    protected void growValuesArray(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public IntBlockBuilder appendNull() {
        super.appendNull();
        return this;
    }

    @Override
    public IntBlockBuilder beginPositionEntry() {
        super.beginPositionEntry();
        return this;
    }

    @Override
    public IntBlockBuilder endPositionEntry() {
        super.endPositionEntry();
        return this;
    }

    @Override
    public IntBlockBuilder copyFrom(Block block, int beginInclusive, int endExclusive) {
        if (block.areAllValuesNull()) {
            for (int p = beginInclusive; p < endExclusive; ++p) {
                this.appendNull();
            }
            return this;
        }
        return this.copyFrom((IntBlock)block, beginInclusive, endExclusive);
    }

    @Override
    public IntBlockBuilder copyFrom(IntBlock block, int beginInclusive, int endExclusive) {
        if (endExclusive > block.getPositionCount()) {
            throw new IllegalArgumentException("can't copy past the end [" + endExclusive + " > " + block.getPositionCount() + "]");
        }
        IntVector vector = block.asVector();
        if (vector != null) {
            this.copyFromVector(vector, beginInclusive, endExclusive);
        } else {
            this.copyFromBlock(block, beginInclusive, endExclusive);
        }
        return this;
    }

    private void copyFromBlock(IntBlock block, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            if (block.isNull(p)) {
                this.appendNull();
                continue;
            }
            int count = block.getValueCount(p);
            if (count > 1) {
                this.beginPositionEntry();
            }
            int i = block.getFirstValueIndex(p);
            for (int v = 0; v < count; ++v) {
                this.appendInt(block.getInt(i++));
            }
            if (count <= 1) continue;
            this.endPositionEntry();
        }
    }

    private void copyFromVector(IntVector vector, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.appendInt(vector.getInt(p));
        }
    }

    @Override
    public IntBlockBuilder mvOrdering(Block.MvOrdering mvOrdering) {
        this.mvOrdering = mvOrdering;
        return this;
    }

    private IntBlock buildBigArraysBlock() {
        IntArray array = this.blockFactory.bigArrays().newIntArray((long)this.valueCount, false);
        for (int i = 0; i < this.valueCount; ++i) {
            array.set((long)i, this.values[i]);
        }
        IntBlock theBlock = this.isDense() && this.singleValued() ? new IntBigArrayVector(array, this.positionCount, this.blockFactory).asBlock() : new IntBigArrayBlock(array, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.blockFactory);
        this.blockFactory.adjustBreaker(theBlock.ramBytesUsed() - this.estimatedBytes - array.ramBytesUsed());
        return theBlock;
    }

    @Override
    public IntBlock build() {
        try {
            this.finish();
            IntBlock theBlock = this.hasNonNullValue && this.positionCount == 1 && this.valueCount == 1 ? this.blockFactory.newConstantIntBlockWith(this.values[0], 1, this.estimatedBytes) : (this.estimatedBytes > this.blockFactory.maxPrimitiveArrayBytes() ? this.buildBigArraysBlock() : (this.isDense() && this.singleValued() ? this.blockFactory.newIntArrayVector(this.values, this.positionCount, this.estimatedBytes).asBlock() : this.blockFactory.newIntArrayBlock(this.values, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.estimatedBytes)));
            this.built();
            return theBlock;
        }
        catch (CircuitBreakingException e) {
            this.close();
            throw e;
        }
    }
}

