/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVectorBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public class DocBlock
extends AbstractVectorBlock
implements Block {
    private final DocVector vector;

    DocBlock(DocVector vector) {
        this.vector = vector;
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException();
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocVector asVector() {
        return this.vector;
    }

    @Override
    public ElementType elementType() {
        return ElementType.DOC;
    }

    @Override
    public Block filter(int ... positions) {
        return new DocBlock(this.asVector().filter(positions));
    }

    @Override
    public Block keepMask(BooleanVector mask) {
        return this.vector.keepMask(mask);
    }

    @Override
    public ReleasableIterator<? extends Block> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("can't lookup values from DocBlock");
    }

    @Override
    public DocBlock expand() {
        this.incRef();
        return this;
    }

    public int hashCode() {
        return this.vector.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DocBlock)) {
            return false;
        }
        return this == obj || this.vector.equals(((DocBlock)obj).vector);
    }

    public long ramBytesUsed() {
        return this.vector.ramBytesUsed();
    }

    @Override
    public void closeInternal() {
        assert (!this.vector.isReleased()) : "can't release block [" + String.valueOf(this) + "] containing already released vector";
        Releasables.closeExpectNoException((Releasable)this.vector);
    }

    public static Builder newBlockBuilder(BlockFactory blockFactory, int estimatedSize) {
        return new Builder(blockFactory, estimatedSize);
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.vector.allowPassingToDifferentDriver();
    }

    @Override
    public int getPositionCount() {
        return this.vector.getPositionCount();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.vector.blockFactory();
    }

    public static class Builder
    implements Block.Builder {
        private final IntVector.Builder shards;
        private final IntVector.Builder segments;
        private final IntVector.Builder docs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Builder(BlockFactory blockFactory, int estimatedSize) {
            IntVector.Builder docs;
            IntVector.Builder segments;
            IntVector.Builder shards;
            block3: {
                shards = null;
                segments = null;
                docs = null;
                try {
                    shards = blockFactory.newIntVectorBuilder(estimatedSize);
                    segments = blockFactory.newIntVectorBuilder(estimatedSize);
                    docs = blockFactory.newIntVectorBuilder(estimatedSize);
                    if (docs != null) break block3;
                }
                catch (Throwable throwable) {
                    if (docs == null) {
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{shards, segments, docs});
                    }
                    throw throwable;
                }
                Releasables.closeExpectNoException((Releasable[])new Releasable[]{shards, segments, docs});
            }
            this.shards = shards;
            this.segments = segments;
            this.docs = docs;
        }

        public Builder appendShard(int shard) {
            this.shards.appendInt(shard);
            return this;
        }

        public Builder appendSegment(int segment) {
            this.segments.appendInt(segment);
            return this;
        }

        public Builder appendDoc(int doc) {
            this.docs.appendInt(doc);
            return this;
        }

        @Override
        public Builder appendNull() {
            throw new UnsupportedOperationException("doc blocks can't contain null");
        }

        @Override
        public Builder beginPositionEntry() {
            throw new UnsupportedOperationException("doc blocks only contain one value per position");
        }

        @Override
        public Builder endPositionEntry() {
            throw new UnsupportedOperationException("doc blocks only contain one value per position");
        }

        @Override
        public Builder copyFrom(Block block, int beginInclusive, int endExclusive) {
            DocVector docVector = ((DocBlock)block).asVector();
            for (int i = beginInclusive; i < endExclusive; ++i) {
                this.shards.appendInt(docVector.shards().getInt(i));
                this.segments.appendInt(docVector.segments().getInt(i));
                this.docs.appendInt(docVector.docs().getInt(i));
            }
            return this;
        }

        @Override
        public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
            return this;
        }

        @Override
        public long estimatedBytes() {
            return DocVector.BASE_RAM_BYTES_USED + this.shards.estimatedBytes() + this.segments.estimatedBytes() + this.docs.estimatedBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DocBlock build() {
            DocBlock docBlock;
            block3: {
                IntVector shards = null;
                IntVector segments = null;
                IntVector docs = null;
                DocVector result = null;
                try {
                    shards = this.shards.build();
                    segments = this.segments.build();
                    docs = this.docs.build();
                    result = new DocVector(shards, segments, docs, null);
                    docBlock = result.asBlock();
                    if (result != null) break block3;
                }
                catch (Throwable throwable) {
                    if (result == null) {
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{shards, segments, docs});
                    }
                    throw throwable;
                }
                Releasables.closeExpectNoException((Releasable[])new Releasable[]{shards, segments, docs});
            }
            return docBlock;
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.shards, this.segments, this.docs});
        }
    }
}

