/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class ValuesBytesRefAggregator {
    ValuesBytesRefAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays) {
        return new SingleState(bigArrays);
    }

    public static void combine(SingleState state, BytesRef v) {
        state.values.add(v);
    }

    public static void combineIntermediate(SingleState state, BytesRefBlock values) {
        BytesRef scratch = new BytesRef();
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            ValuesBytesRefAggregator.combine(state, values.getBytesRef(i, scratch));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(DriverContext driverContext) {
        return new GroupingState(driverContext);
    }

    public static void combine(GroupingState state, int groupId, BytesRef v) {
        state.addValue(groupId, v);
    }

    public static void combineIntermediate(GroupingState state, int groupId, BytesRefBlock values, int valuesPosition) {
        BytesRef scratch = new BytesRef();
        int start = values.getFirstValueIndex(valuesPosition);
        int end = start + values.getValueCount(valuesPosition);
        for (int i = start; i < end; ++i) {
            state.addValue(groupId, values.getBytesRef(i, scratch));
        }
    }

    public static void combineStates(GroupingState current, int currentGroupId, GroupingState state, int statePosition) {
        if (statePosition > state.maxGroupId) {
            return;
        }
        Sorted sorted = state.sortedForOrdinalMerging(current);
        int start = statePosition > 0 ? sorted.counts[statePosition - 1] : 0;
        int end = sorted.counts[statePosition];
        for (int i = start; i < end; ++i) {
            int id = sorted.ids[i];
            current.addValueOrdinal(currentGroupId, id);
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory(), selected);
    }

    public static class SingleState
    implements Releasable {
        private final BytesRefHash values;

        private SingleState(BigArrays bigArrays) {
            this.values = new BytesRefHash(1L, bigArrays);
        }

        void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            BytesRef scratch = new BytesRef();
            if (this.values.size() == 1L) {
                return blockFactory.newConstantBytesRefBlockWith(BytesRef.deepCopyOf((BytesRef)this.values.get(0L, scratch)), 1);
            }
            try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder((int)this.values.size());){
                builder.beginPositionEntry();
                int id = 0;
                while ((long)id < this.values.size()) {
                    builder.appendBytesRef(this.values.get((long)id, scratch));
                    ++id;
                }
                builder.endPositionEntry();
                BytesRefBlock bytesRefBlock = builder.build();
                return bytesRefBlock;
            }
        }

        public void close() {
            this.values.close();
        }
    }

    public static class GroupingState
    implements GroupingAggregatorState {
        private int maxGroupId = -1;
        private final BlockFactory blockFactory;
        private final LongLongHash values;
        private BytesRefHash bytes;
        private Sorted sortedForOrdinalMerging = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GroupingState(DriverContext driverContext) {
            this.blockFactory = driverContext.blockFactory();
            LongLongHash _values = null;
            BytesRefHash _bytes = null;
            try {
                _values = new LongLongHash(1L, driverContext.bigArrays());
                _bytes = new BytesRefHash(1L, driverContext.bigArrays());
                this.values = _values;
                this.bytes = _bytes;
                _values = null;
                _bytes = null;
            }
            catch (Throwable throwable) {
                Releasables.closeExpectNoException((Releasable[])new Releasable[]{_values, _bytes});
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{_values, _bytes});
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        void addValueOrdinal(int groupId, long valueOrdinal) {
            this.values.add((long)groupId, valueOrdinal);
            this.maxGroupId = Math.max(this.maxGroupId, groupId);
        }

        void addValue(int groupId, BytesRef v) {
            this.values.add((long)groupId, BlockHash.hashOrdToGroup(this.bytes.add(v)));
            this.maxGroupId = Math.max(this.maxGroupId, groupId);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(selected.getPositionCount());
            }
            try (Sorted sorted = this.buildSorted(selected);){
                Block block = this.buildOutputBlock(blockFactory, selected, sorted.counts, sorted.ids);
                return block;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Sorted buildSorted(IntVector selected) {
            long selectedCountsSize = 0L;
            long idsSize = 0L;
            Sorted sorted = null;
            try {
                int selectedCountsLen = selected.max() + 1;
                long adjust = RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + selectedCountsLen * 4));
                this.blockFactory.adjustBreaker(adjust);
                selectedCountsSize = adjust;
                int[] selectedCounts = new int[selectedCountsLen];
                int id = 0;
                while ((long)id < this.values.size()) {
                    int group = (int)this.values.getKey1((long)id);
                    if (group < selectedCounts.length) {
                        int n = group;
                        selectedCounts[n] = selectedCounts[n] - 1;
                    }
                    ++id;
                }
                int total = 0;
                for (int s = 0; s < selected.getPositionCount(); ++s) {
                    int group = selected.getInt(s);
                    int count = -selectedCounts[group];
                    selectedCounts[group] = total;
                    total += count;
                }
                adjust = RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + total * 4));
                this.blockFactory.adjustBreaker(adjust);
                idsSize = adjust;
                int[] ids = new int[total];
                int id2 = 0;
                while ((long)id2 < this.values.size()) {
                    int group = (int)this.values.getKey1((long)id2);
                    if (group < selectedCounts.length && selectedCounts[group] >= 0) {
                        int n = group;
                        int n2 = selectedCounts[n];
                        selectedCounts[n] = n2 + 1;
                        ids[n2] = id2;
                    }
                    ++id2;
                }
                long totalMemoryUsed = selectedCountsSize + idsSize;
                Sorted sorted2 = sorted = new Sorted(() -> this.blockFactory.adjustBreaker(-totalMemoryUsed), selectedCounts, ids);
                return sorted2;
            }
            finally {
                if (sorted == null) {
                    this.blockFactory.adjustBreaker(-selectedCountsSize - idsSize);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Sorted sortedForOrdinalMerging(GroupingState other) {
            if (this.sortedForOrdinalMerging == null) {
                try (IntVector selected = IntVector.range(0, this.maxGroupId + 1, this.blockFactory);){
                    this.sortedForOrdinalMerging = this.buildSorted(selected);
                    BytesRef scratch = new BytesRef();
                    int totalValue = Math.toIntExact(this.bytes.size());
                    this.blockFactory.adjustBreaker((long)totalValue * 4L);
                    try {
                        int i;
                        int[] mappedIds = new int[totalValue];
                        for (i = 0; i < totalValue; ++i) {
                            BytesRef v = this.bytes.get((long)i, scratch);
                            mappedIds[i] = Math.toIntExact(BlockHash.hashOrdToGroup(other.bytes.add(v)));
                        }
                        this.bytes.close();
                        this.bytes = null;
                        for (i = 0; i < this.sortedForOrdinalMerging.ids.length; ++i) {
                            this.sortedForOrdinalMerging.ids[i] = mappedIds[Math.toIntExact(this.values.getKey2((long)this.sortedForOrdinalMerging.ids[i]))];
                        }
                    }
                    finally {
                        this.blockFactory.adjustBreaker(-((long)totalValue) * 4L);
                    }
                }
            }
            return this.sortedForOrdinalMerging;
        }

        Block buildOutputBlock(BlockFactory blockFactory, IntVector selected, int[] selectedCounts, int[] ids) {
            BytesRef scratch = new BytesRef();
            try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder(selected.getPositionCount());){
                int start = 0;
                for (int s = 0; s < selected.getPositionCount(); ++s) {
                    int group = selected.getInt(s);
                    int end = selectedCounts[group];
                    int count = end - start;
                    switch (count) {
                        case 0: {
                            builder.appendNull();
                            break;
                        }
                        case 1: {
                            builder.appendBytesRef(this.getValue(ids[start], scratch));
                            break;
                        }
                        default: {
                            builder.beginPositionEntry();
                            for (int i = start; i < end; ++i) {
                                builder.appendBytesRef(this.getValue(ids[i], scratch));
                            }
                            builder.endPositionEntry();
                        }
                    }
                    start = end;
                }
                BytesRefBlock bytesRefBlock = builder.build();
                return bytesRefBlock;
            }
        }

        BytesRef getValue(int valueId, BytesRef scratch) {
            return this.bytes.get(this.values.getKey2((long)valueId), scratch);
        }

        public void enableGroupIdTracking(SeenGroupIds seen) {
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.values, this.bytes, this.sortedForOrdinalMerging});
        }
    }

    private record Sorted(Releasable releasable, int[] counts, int[] ids) implements Releasable
    {
        public void close() {
            this.releasable.close();
        }
    }
}

