/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.rest;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.textstructure.action.AbstractFindStructureRequest;
import org.elasticsearch.xpack.core.textstructure.action.FindStructureAction;
import org.elasticsearch.xpack.textstructure.rest.RestFindStructureArgumentsParser;

@ServerlessScope(value=Scope.INTERNAL)
public class RestFindStructureAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_text_structure/find_structure").replaces(RestRequest.Method.POST, "/_ml/find_file_structure", RestApiVersion.V_8).build());
    }

    public String getName() {
        return "text_structure_find_structure_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        FindStructureAction.Request request = new FindStructureAction.Request();
        RestFindStructureArgumentsParser.parse(restRequest, (AbstractFindStructureRequest)request);
        if (!restRequest.hasContent()) {
            throw new ElasticsearchParseException("request body is required", new Object[0]);
        }
        request.setSample(restRequest.content());
        return channel -> client.execute((ActionType)FindStructureAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    protected Set<String> responseParams() {
        return Collections.singleton("explain");
    }
}

