/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.persistence;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ClusterAdminClient;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessage;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.DestConfig;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;

public final class TransformInternalIndex {
    public static final int TRANSFORM_INDEX_MAPPINGS_VERSION = 1;
    private static final String LEGACY_VERSION_FIELD_VALUE = "8.11.0";
    public static final String DYNAMIC = "dynamic";
    public static final String PROPERTIES = "properties";
    public static final String TYPE = "type";
    public static final String ENABLED = "enabled";
    public static final String DATE = "date";
    public static final String TEXT = "text";
    public static final String FIELDS = "fields";
    public static final String RAW = "raw";
    public static final String IGNORE_ABOVE = "ignore_above";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String LONG = "long";
    public static final String KEYWORD = "keyword";
    public static final String BOOLEAN = "boolean";
    public static final String FLATTENED = "flattened";

    public static SystemIndexDescriptor getSystemIndexDescriptor(Settings transformInternalIndexAdditionalSettings) throws IOException {
        return SystemIndexDescriptor.builder().setIndexPattern(".transform-internal-*").setPrimaryIndex(".transform-internal-007").setDescription("Contains Transform configuration data").setMappings(TransformInternalIndex.mappings()).setSettings(TransformInternalIndex.settings(transformInternalIndexAdditionalSettings)).setVersionMetaKey("version").setOrigin("transform").build();
    }

    public static Template getAuditIndexTemplate() throws IOException {
        AliasMetadata alias = AliasMetadata.builder((String)".transform-notifications-read").isHidden(Boolean.valueOf(true)).build();
        return new Template(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put("index.hidden", true).build(), new CompressedXContent(Strings.toString((XContentBuilder)TransformInternalIndex.auditMappings())), Collections.singletonMap(alias.alias(), alias));
    }

    private static XContentBuilder auditMappings() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        builder.startObject("_doc");
        TransformInternalIndex.addMetaInformation(builder);
        builder.field(DYNAMIC, "false");
        builder.startObject(PROPERTIES).startObject("transform_id").field(TYPE, KEYWORD).endObject().startObject(AbstractAuditMessage.LEVEL.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(AbstractAuditMessage.MESSAGE.getPreferredName()).field(TYPE, TEXT).startObject(FIELDS).startObject(RAW).field(TYPE, KEYWORD).field(IGNORE_ABOVE, 1024).endObject().endObject().endObject().startObject(AbstractAuditMessage.TIMESTAMP.getPreferredName()).field(TYPE, DATE).endObject().startObject(AbstractAuditMessage.NODE_NAME.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().endObject();
        return builder;
    }

    public static Settings settings(Settings additionalSettings) {
        assert (additionalSettings != null);
        return Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put(additionalSettings).build();
    }

    public static XContentBuilder mappings() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        return TransformInternalIndex.mappings(builder);
    }

    public static XContentBuilder mappings(XContentBuilder builder) throws IOException {
        builder.startObject();
        builder.startObject("_doc");
        TransformInternalIndex.addMetaInformation(builder);
        builder.field(DYNAMIC, "false");
        builder.startObject(PROPERTIES);
        builder.startObject(TransformField.INDEX_DOC_TYPE.getPreferredName()).field(TYPE, KEYWORD).endObject();
        TransformInternalIndex.addTransformsConfigMappings(builder);
        TransformInternalIndex.addTransformStoredDocMappings(builder);
        TransformInternalIndex.addTransformCheckpointMappings(builder);
        builder.endObject();
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static XContentBuilder addTransformStoredDocMappings(XContentBuilder builder) throws IOException {
        return builder.startObject(TransformStoredDoc.STATE_FIELD.getPreferredName()).startObject(PROPERTIES).startObject(TransformState.TASK_STATE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(TransformState.INDEXER_STATE.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(TransformState.SHOULD_STOP_AT_NEXT_CHECKPOINT.getPreferredName()).field(TYPE, BOOLEAN).endObject().startObject(TransformState.CURRENT_POSITION.getPreferredName()).field(ENABLED, false).endObject().startObject(TransformState.CHECKPOINT.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformState.REASON.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(TransformState.PROGRESS.getPreferredName()).startObject(PROPERTIES).startObject(TransformProgress.TOTAL_DOCS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformProgress.DOCS_REMAINING.getPreferredName()).field(TYPE, LONG).endObject().startObject("percent_complete").field(TYPE, FLOAT).endObject().startObject(TransformProgress.DOCS_INDEXED.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformProgress.DOCS_PROCESSED.getPreferredName()).field(TYPE, LONG).endObject().endObject().endObject().endObject().endObject().startObject(TransformField.STATS_FIELD.getPreferredName()).startObject(PROPERTIES).startObject(TransformIndexerStats.NUM_PAGES.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.NUM_INPUT_DOCUMENTS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.NUM_OUTPUT_DOCUMENTS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.NUM_DELETED_DOCUMENTS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.NUM_INVOCATIONS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.INDEX_TIME_IN_MS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.SEARCH_TIME_IN_MS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.PROCESSING_TIME_IN_MS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.DELETE_TIME_IN_MS.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.INDEX_TOTAL.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.SEARCH_TOTAL.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.PROCESSING_TOTAL.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.SEARCH_FAILURES.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.INDEX_FAILURES.getPreferredName()).field(TYPE, LONG).endObject().startObject(TransformIndexerStats.EXPONENTIAL_AVG_CHECKPOINT_DURATION_MS.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(TransformIndexerStats.EXPONENTIAL_AVG_DOCUMENTS_INDEXED.getPreferredName()).field(TYPE, DOUBLE).endObject().startObject(TransformIndexerStats.EXPONENTIAL_AVG_DOCUMENTS_PROCESSED.getPreferredName()).field(TYPE, DOUBLE).endObject().endObject().endObject();
    }

    public static XContentBuilder addTransformsConfigMappings(XContentBuilder builder) throws IOException {
        return builder.startObject(TransformField.ID.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(TransformField.SOURCE.getPreferredName()).startObject(PROPERTIES).startObject(SourceConfig.INDEX.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(SourceConfig.QUERY.getPreferredName()).field(ENABLED, false).endObject().endObject().endObject().startObject(TransformField.DESTINATION.getPreferredName()).startObject(PROPERTIES).startObject(DestConfig.INDEX.getPreferredName()).field(TYPE, KEYWORD).endObject().endObject().endObject().startObject(TransformField.DESCRIPTION.getPreferredName()).field(TYPE, TEXT).endObject().startObject(TransformField.VERSION.getPreferredName()).field(TYPE, KEYWORD).endObject().startObject(TransformField.CREATE_TIME.getPreferredName()).field(TYPE, DATE).endObject().startObject(TransformConfig.Function.PIVOT.getParseField().getPreferredName()).field(TYPE, FLATTENED).endObject().startObject(TransformConfig.Function.LATEST.getParseField().getPreferredName()).field(TYPE, FLATTENED).endObject().startObject(TransformField.METADATA.getPreferredName()).field(TYPE, FLATTENED).endObject().startObject(TransformField.RETENTION_POLICY.getPreferredName()).field(TYPE, FLATTENED).endObject().startObject(TransformField.SYNC.getPreferredName()).field(TYPE, FLATTENED).endObject();
    }

    private static XContentBuilder addTransformCheckpointMappings(XContentBuilder builder) throws IOException {
        return builder.startObject(TransformField.TIMESTAMP_MILLIS.getPreferredName()).field(TYPE, DATE).endObject().startObject(TransformField.TIME_UPPER_BOUND_MILLIS.getPreferredName()).field(TYPE, DATE).endObject().startObject(TransformCheckpoint.CHECKPOINT.getPreferredName()).field(TYPE, LONG).endObject();
    }

    private static XContentBuilder addMetaInformation(XContentBuilder builder) throws IOException {
        return builder.startObject("_meta").field("version", LEGACY_VERSION_FIELD_VALUE).field("managed_index_mappings_version", 1).endObject();
    }

    protected static boolean hasLatestVersionedIndex(ClusterState state) {
        return state.getMetadata().hasIndexAbstraction(".transform-internal-007");
    }

    protected static boolean allPrimaryShardsActiveForLatestVersionedIndex(ClusterState state) {
        IndexRoutingTable indexRouting = state.routingTable().index(".transform-internal-007");
        return indexRouting != null && indexRouting.allPrimaryShardsActive() && indexRouting.readyForSearch(state);
    }

    private static void waitForLatestVersionedIndexShardsActive(Client client, ActionListener<Void> listener) {
        ClusterHealthRequest request = new ClusterHealthRequest(TimeValue.THIRTY_SECONDS, new String[]{".transform-internal-007"}).waitForActiveShards(ActiveShardCount.ONE);
        ActionListener innerListener = ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0));
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"transform", (Object)request, (ActionListener)innerListener, (arg_0, arg_1) -> ((ClusterAdminClient)client.admin().cluster()).health(arg_0, arg_1));
    }

    public static void createLatestVersionedIndexIfRequired(ClusterService clusterService, Client client, Settings transformInternalIndexAdditionalSettings, ActionListener<Void> listener) {
        ClusterState state = clusterService.state();
        if (TransformInternalIndex.hasLatestVersionedIndex(state)) {
            if (TransformInternalIndex.allPrimaryShardsActiveForLatestVersionedIndex(state)) {
                listener.onResponse(null);
                return;
            }
            TransformInternalIndex.waitForLatestVersionedIndexShardsActive(client, listener);
            return;
        }
        try {
            CreateIndexRequest request = new CreateIndexRequest(".transform-internal-007").settings(TransformInternalIndex.settings(transformInternalIndexAdditionalSettings)).mapping(TransformInternalIndex.mappings()).origin("transform").waitForActiveShards(ActiveShardCount.ONE);
            ActionListener innerListener = ActionListener.wrap(r -> listener.onResponse(null), e -> {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                    if (TransformInternalIndex.allPrimaryShardsActiveForLatestVersionedIndex(clusterService.state())) {
                        listener.onResponse(null);
                        return;
                    }
                    TransformInternalIndex.waitForLatestVersionedIndexShardsActive(client, listener);
                } else {
                    listener.onFailure(e);
                }
            });
            ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"transform", (Object)request, (ActionListener)innerListener, (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).create(arg_0, arg_1));
        }
        catch (IOException e2) {
            listener.onFailure((Exception)e2);
        }
    }

    private TransformInternalIndex() {
    }
}

