/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.spatial.index.fielddata.CartesianShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.ShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.CartesianBoundsAggregatorBase;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianShapeValuesSource;

public final class CartesianShapeBoundsAggregator
extends CartesianBoundsAggregatorBase {
    private final CartesianShapeValuesSource valuesSource;

    public CartesianShapeBoundsAggregator(String name, AggregationContext context, Aggregator parent, ValuesSourceConfig valuesSourceConfig, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (CartesianShapeValuesSource)valuesSourceConfig.getValuesSource();
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) {
        final CartesianShapeValues values = (CartesianShapeValues)this.valuesSource.shapeValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    CartesianShapeBoundsAggregator.this.maybeResize(bucket);
                    CartesianShapeValues.CartesianShapeValue value = (CartesianShapeValues.CartesianShapeValue)values.value();
                    ShapeValues.BoundingBox bounds = value.boundingBox();
                    CartesianShapeBoundsAggregator.this.addBounds(bucket, bounds.top, bounds.bottom, bounds.minX(), bounds.maxX());
                }
            }
        };
    }
}

