/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;

class LoadAuthorizedIndicesTimeChecker
implements Consumer<Collection<String>> {
    private final Logger logger;
    private final long startNanos;
    private final AuthorizationEngine.RequestInfo requestInfo;
    private final Thresholds thresholds;
    static final Setting<Boolean> LOGGING_ENABLED_SETTING = Setting.boolSetting((String)"xpack.security.authz.timer.indices.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<TimeValue> DEBUG_THRESHOLD_SETTING = Setting.timeSetting((String)"xpack.security.authz.timer.indices.threshold.debug", (TimeValue)TimeValue.timeValueMillis((long)20L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> INFO_THRESHOLD_SETTING = Setting.timeSetting((String)"xpack.security.authz.timer.indices.threshold.info", (TimeValue)TimeValue.timeValueMillis((long)100L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> WARN_THRESHOLD_SETTING = Setting.timeSetting((String)"xpack.security.authz.timer.indices.threshold.warn", (TimeValue)TimeValue.timeValueMillis((long)200L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Consumer<Collection<String>> NO_OP_CONSUMER = ignore -> {};

    LoadAuthorizedIndicesTimeChecker(Logger logger, long startNanos, AuthorizationEngine.RequestInfo requestInfo, Thresholds thresholds) {
        this.logger = logger;
        this.startNanos = startNanos;
        this.requestInfo = requestInfo;
        this.thresholds = thresholds;
    }

    @Override
    public void accept(Collection<String> indices) {
        long end = System.nanoTime();
        long millis = TimeUnit.NANOSECONDS.toMillis(end - this.startNanos);
        Level level = this.thresholds.getLogLevel(millis);
        if (level == Level.WARN) {
            this.logger.warn("Resolving [{}] indices for action [{}] and user [{}] took [{}ms] which is greater than the threshold of {}ms; The index privileges for this user may be too complex for this cluster.", (Object)indices.size(), (Object)this.requestInfo.getAction(), (Object)this.requestInfo.getAuthentication().getEffectiveSubject().getUser().principal(), (Object)millis, (Object)this.thresholds.warnThresholdMs);
        } else {
            this.logger.log(level, "Took [{}ms] to resolve [{}] indices for action [{}] and user [{}]", (Object)millis, (Object)indices.size(), (Object)this.requestInfo.getAction(), (Object)this.requestInfo.getAuthentication().getEffectiveSubject().getUser().principal());
        }
    }

    static class Thresholds {
        private final long debugThresholdMs;
        private final long infoThresholdMs;
        private final long warnThresholdMs;

        Thresholds(TimeValue debugThreshold, TimeValue infoThreshold, TimeValue warnThreshold) {
            this.debugThresholdMs = debugThreshold.millis();
            this.infoThresholdMs = infoThreshold.millis();
            this.warnThresholdMs = warnThreshold.millis();
        }

        public Level getLogLevel(long millis) {
            if (millis > this.warnThresholdMs) {
                return Level.WARN;
            }
            if (millis > this.infoThresholdMs) {
                return Level.INFO;
            }
            if (millis > this.debugThresholdMs) {
                return Level.DEBUG;
            }
            return Level.TRACE;
        }

        long getDebugThresholdMs() {
            return this.debugThresholdMs;
        }

        long getInfoThresholdMs() {
            return this.infoThresholdMs;
        }

        long getWarnThresholdMs() {
            return this.warnThresholdMs;
        }
    }

    static class Factory {
        private final Logger logger;
        private volatile boolean loggingEnabled;
        private final Thresholds thresholds;

        Factory(Logger logger, Settings settings, ClusterSettings clusterSettings) {
            this.logger = logger;
            this.loggingEnabled = (Boolean)LOGGING_ENABLED_SETTING.get(settings);
            clusterSettings.addSettingsUpdateConsumer(LOGGING_ENABLED_SETTING, enabled -> {
                this.loggingEnabled = enabled;
            });
            TimeValue debugThreshold = (TimeValue)DEBUG_THRESHOLD_SETTING.get(settings);
            TimeValue infoThreshold = (TimeValue)INFO_THRESHOLD_SETTING.get(settings);
            TimeValue warnThreshold = (TimeValue)WARN_THRESHOLD_SETTING.get(settings);
            if (infoThreshold.compareTo(debugThreshold) < 0) {
                throw new SettingsException("Setting [{}] ({}) cannot be less than the setting [{}] ({})", new Object[]{INFO_THRESHOLD_SETTING.getKey(), infoThreshold, DEBUG_THRESHOLD_SETTING.getKey(), debugThreshold});
            }
            if (warnThreshold.compareTo(infoThreshold) < 0) {
                throw new SettingsException("Setting [{}] ({}) cannot be less than the setting [{}] ({})", new Object[]{WARN_THRESHOLD_SETTING.getKey(), warnThreshold, INFO_THRESHOLD_SETTING.getKey(), infoThreshold});
            }
            this.thresholds = new Thresholds(debugThreshold, infoThreshold, warnThreshold);
        }

        public static Set<Setting<?>> getSettings() {
            return Set.of(LOGGING_ENABLED_SETTING, DEBUG_THRESHOLD_SETTING, INFO_THRESHOLD_SETTING, WARN_THRESHOLD_SETTING);
        }

        public Consumer<Collection<String>> newTimer(AuthorizationEngine.RequestInfo requestInfo) {
            if (this.loggingEnabled) {
                return new LoadAuthorizedIndicesTimeChecker(this.logger, System.nanoTime(), requestInfo, this.thresholds);
            }
            return NO_OP_CONSUMER;
        }

        public Thresholds getThresholds() {
            return this.thresholds;
        }
    }
}

