/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.support;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xpack.idp.saml.support.SamlInit;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Credential;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SamlFactory {
    private final XMLObjectBuilderFactory builderFactory;
    private final SecureRandom random;
    private static final Logger LOGGER = LogManager.getLogger(SamlFactory.class);

    public SamlFactory() {
        SamlInit.initialize();
        this.builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.random = new SecureRandom();
    }

    public <T extends XMLObject> T object(Class<T> type, QName elementName) {
        XMLObject obj = this.builderFactory.getBuilder(elementName).buildObject(elementName);
        return SamlFactory.cast(type, elementName, obj);
    }

    public <T extends XMLObject> T object(Class<T> type, QName elementName, QName schemaType) {
        XMLObject obj = this.builderFactory.getBuilder(schemaType).buildObject(elementName, schemaType);
        return SamlFactory.cast(type, elementName, obj);
    }

    private static <T extends XMLObject> T cast(Class<T> type, QName elementName, XMLObject obj) {
        if (type.isInstance(obj)) {
            return (T)((XMLObject)type.cast(obj));
        }
        throw new IllegalArgumentException("Object for element " + elementName.getLocalPart() + " is of type " + String.valueOf(obj.getClass()) + " not " + String.valueOf(type));
    }

    public String secureIdentifier() {
        return this.randomNCName(20);
    }

    private String randomNCName(int numberBytes) {
        byte[] randomBytes = new byte[numberBytes];
        this.random.nextBytes(randomBytes);
        return "_".concat(MessageDigests.toHexString((byte[])randomBytes));
    }

    public <T extends XMLObject> T buildObject(Class<T> type, QName elementName) {
        XMLObject obj = this.builderFactory.getBuilder(elementName).buildObject(elementName);
        if (type.isInstance(obj)) {
            return (T)((XMLObject)type.cast(obj));
        }
        throw new IllegalArgumentException("Object for element " + elementName.getLocalPart() + " is of type " + String.valueOf(obj.getClass()) + " not " + String.valueOf(type));
    }

    public String toString(Element element, boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            this.print(element, writer, pretty);
            return writer.toString();
        }
        catch (TransformerException e) {
            return "[" + element.getNamespaceURI() + "]" + element.getLocalName();
        }
    }

    public static <T extends XMLObject> T buildXmlObject(Element element, Class<T> type) {
        try {
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            if (unmarshaller == null) {
                throw new ElasticsearchSecurityException("XML element [{}] cannot be unmarshalled to SAML type [{}] (no unmarshaller)", new Object[]{element.getTagName(), type});
            }
            XMLObject object = unmarshaller.unmarshall(element);
            if (type.isInstance(object)) {
                return (T)((XMLObject)type.cast(object));
            }
            Object[] args = new Object[]{element.getTagName(), type.getName(), object.getClass().getName()};
            throw new ElasticsearchSecurityException("SAML object [{}] is incorrect type. Expected [{}] but was [{}]", args);
        }
        catch (UnmarshallingException e) {
            throw new ElasticsearchSecurityException("Failed to unmarshall SAML content [{}]", (Exception)((Object)e), new Object[]{element.getTagName()});
        }
    }

    void print(Element element, Writer writer, boolean pretty) throws TransformerException {
        Transformer serializer = SamlFactory.getHardenedXMLTransformer();
        if (pretty) {
            serializer.setOutputProperty("indent", "yes");
        }
        serializer.transform(new DOMSource(element), new StreamResult(writer));
    }

    public String getXmlContent(SAMLObject object) {
        return this.getXmlContent(object, false);
    }

    public String getXmlContent(SAMLObject object, boolean prettyPrint) {
        try {
            return this.toString(XMLObjectSupport.marshall((XMLObject)object), prettyPrint);
        }
        catch (MarshallingException e) {
            LOGGER.info("Error marshalling SAMLObject ", (Throwable)e);
            return "_unserializable_";
        }
    }

    public static boolean elementNameMatches(Element element, String namespace, String localName) {
        return localName.equals(element.getLocalName()) && namespace.equals(element.getNamespaceURI());
    }

    public static String text(Element dom, int length) {
        return SamlFactory.text(dom, length, 0);
    }

    protected static String text(Element dom, int prefixLength, int suffixLength) {
        String text = dom.getTextContent().trim();
        int totalLength = prefixLength + suffixLength;
        if (text.length() > totalLength) {
            String prefix = Strings.cleanTruncate((String)text, (int)prefixLength) + "...";
            if (suffixLength == 0) {
                return prefix;
            }
            int suffixIndex = text.length() - suffixLength;
            if (Character.isHighSurrogate(text.charAt(suffixIndex))) {
                ++suffixIndex;
            }
            return prefix + text.substring(suffixIndex);
        }
        return text;
    }

    public static String describeCredentials(Collection<? extends Credential> credentials) {
        return credentials.stream().map(c -> {
            byte[] encoded;
            if (c == null) {
                return "<null>";
            }
            if (c instanceof X509Credential) {
                X509Credential x = (X509Credential)c;
                try {
                    encoded = x.getEntityCertificate().getEncoded();
                }
                catch (CertificateEncodingException e) {
                    encoded = c.getPublicKey().getEncoded();
                }
            } else {
                encoded = c.getPublicKey().getEncoded();
            }
            return Base64.getEncoder().encodeToString(encoded).substring(0, 64) + "...";
        }).collect(Collectors.joining(","));
    }

    public static Element toDomElement(XMLObject object) {
        try {
            return XMLObjectSupport.marshall((XMLObject)object);
        }
        catch (MarshallingException e) {
            throw new ElasticsearchSecurityException("failed to marshall SAML object to DOM element", (Exception)((Object)e), new Object[0]);
        }
    }

    @SuppressForbidden(reason="This is the only allowed way to construct a Transformer")
    public static Transformer getHardenedXMLTransformer() throws TransformerConfigurationException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        tfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        tfactory.setAttribute("indent-number", 2);
        Transformer transformer = tfactory.newTransformer();
        transformer.setErrorListener(new TransformerErrorListener());
        return transformer;
    }

    @SuppressForbidden(reason="This is the only allowed way to construct a DocumentBuilder")
    public static DocumentBuilder getHardenedBuilder(String[] schemaFiles) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setFeature("http://xml.org/sax/features/validation", true);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setIgnoringComments(true);
        dbf.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "file,jar");
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "file,jar");
        dbf.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setAttribute("http://apache.org/xml/features/validation/schema", true);
        dbf.setAttribute("http://apache.org/xml/features/validation/schema-full-checking", true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", SamlFactory.resolveSchemaFilePaths(schemaFiles));
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        documentBuilder.setErrorHandler(new DocumentBuilderErrorHandler());
        return documentBuilder;
    }

    public static String getJavaAlorithmNameFromUri(String sigAlg) {
        return switch (sigAlg) {
            case "http://www.w3.org/2000/09/xmldsig#dsa-sha1" -> "SHA1withDSA";
            case "http://www.w3.org/2000/09/xmldsig#dsa-sha256" -> "SHA256withDSA";
            case "http://www.w3.org/2000/09/xmldsig#rsa-sha1" -> "SHA1withRSA";
            case "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256" -> "SHA256withRSA";
            case "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256" -> "SHA256withECDSA";
            default -> throw new IllegalArgumentException("Unsupported signing algorithm identifier: " + sigAlg);
        };
    }

    private static String[] resolveSchemaFilePaths(String[] relativePaths) {
        return (String[])Arrays.stream(relativePaths).map(file -> {
            try {
                return SamlFactory.class.getResource((String)file).toURI().toString();
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Error resolving schema file path", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toArray(String[]::new);
    }

    private static class TransformerErrorListener
    implements ErrorListener {
        private TransformerErrorListener() {
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            LOGGER.debug("XML transformation error", (Throwable)e);
            throw e;
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            this.warning(e);
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            this.warning(e);
        }
    }

    private static class DocumentBuilderErrorHandler
    implements ErrorHandler {
        private DocumentBuilderErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            LOGGER.debug("XML Parser error ", (Throwable)e);
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.warning(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.warning(e);
        }
    }
}

