/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils.persistence;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;
import org.elasticsearch.xpack.ml.utils.persistence.BatchedIterator;

public abstract class BatchedDocumentsIterator<T>
implements BatchedIterator<T> {
    private static final Logger LOGGER = LogManager.getLogger(BatchedDocumentsIterator.class);
    private static final TimeValue CONTEXT_ALIVE_DURATION = TimeValue.timeValueMinutes((long)5L);
    private static final int BATCH_SIZE = 10000;
    private final OriginSettingClient client;
    private final String index;
    private volatile long count;
    private volatile long totalHits;
    private volatile String scrollId;
    private volatile boolean isScrollInitialised;

    protected BatchedDocumentsIterator(OriginSettingClient client, String index) {
        this.client = Objects.requireNonNull(client);
        this.index = Objects.requireNonNull(index);
        this.totalHits = 0L;
        this.count = 0L;
        this.isScrollInitialised = false;
    }

    @Override
    public boolean hasNext() {
        return !this.isScrollInitialised || this.count != this.totalHits;
    }

    @Override
    public Deque<T> next() {
        SearchResponse searchResponse;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.scrollId == null) {
            searchResponse = this.initScroll();
        } else {
            SearchScrollRequest searchScrollRequest = new SearchScrollRequest(this.scrollId).scroll(CONTEXT_ALIVE_DURATION);
            searchResponse = (SearchResponse)this.client.searchScroll(searchScrollRequest).actionGet();
        }
        try {
            this.scrollId = searchResponse.getScrollId();
            Deque<T> deque = this.mapHits(searchResponse);
            return deque;
        }
        finally {
            searchResponse.decRef();
        }
    }

    private SearchResponse initScroll() {
        LOGGER.trace("ES API CALL: search index {}", (Object)this.index);
        this.isScrollInitialised = true;
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
        searchRequest.scroll(CONTEXT_ALIVE_DURATION);
        searchRequest.source(new SearchSourceBuilder().size(10000).query(this.getQuery()).fetchSource(this.shouldFetchSource()).trackTotalHits(true).sort((SortBuilder)SortBuilders.fieldSort((String)"_doc")));
        SearchResponse searchResponse = (SearchResponse)this.client.search(searchRequest).actionGet();
        this.totalHits = searchResponse.getHits().getTotalHits().value;
        this.scrollId = searchResponse.getScrollId();
        return searchResponse;
    }

    private Deque<T> mapHits(SearchResponse searchResponse) {
        SearchHit[] hits;
        ArrayDeque<T> results = new ArrayDeque<T>();
        for (SearchHit hit : hits = searchResponse.getHits().getHits()) {
            T mapped = this.map(hit);
            if (mapped == null) continue;
            results.add(mapped);
        }
        this.count += (long)hits.length;
        if (!this.hasNext() && this.scrollId != null) {
            this.client.prepareClearScroll().setScrollIds(Collections.singletonList(this.scrollId)).get();
        }
        return results;
    }

    protected boolean shouldFetchSource() {
        return true;
    }

    protected abstract QueryBuilder getQuery();

    protected abstract T map(SearchHit var1);
}

