/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.dataframe;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.ExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

@ServerlessScope(value=Scope.INTERNAL)
public class RestExplainDataFrameAnalyticsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_ml/data_frame/analytics/_explain"), new RestHandler.Route(RestRequest.Method.POST, "/_ml/data_frame/analytics/_explain"), new RestHandler.Route(RestRequest.Method.GET, "/_ml/data_frame/analytics/{" + String.valueOf(DataFrameAnalyticsConfig.ID) + "}/_explain"), new RestHandler.Route(RestRequest.Method.POST, "/_ml/data_frame/analytics/{" + String.valueOf(DataFrameAnalyticsConfig.ID) + "}/_explain"));
    }

    public String getName() {
        return "ml_explain_data_frame_analytics_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String jobId = restRequest.param(DataFrameAnalyticsConfig.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)jobId) && !restRequest.hasContentOrSourceParam()) {
            throw ExceptionsHelper.badRequestException((String)"Please provide a job [{}] or the config object", (Object[])new Object[]{DataFrameAnalyticsConfig.ID.getPreferredName()});
        }
        if (!Strings.isNullOrEmpty((String)jobId) && restRequest.hasContentOrSourceParam()) {
            throw ExceptionsHelper.badRequestException((String)"Please provide either a job [{}] or the config object but not both", (Object[])new Object[]{DataFrameAnalyticsConfig.ID.getPreferredName()});
        }
        ExplainDataFrameAnalyticsAction.Request explainRequestFromBody = Strings.isNullOrEmpty((String)jobId) ? ExplainDataFrameAnalyticsAction.Request.parseRequest((XContentParser)restRequest.contentOrSourceParamParser()) : null;
        return channel -> {
            RestToXContentListener listener = new RestToXContentListener(channel);
            RestCancellableNodeClient cancellableClient = new RestCancellableNodeClient(client, restRequest.getHttpChannel());
            if (explainRequestFromBody != null) {
                cancellableClient.execute((ActionType)ExplainDataFrameAnalyticsAction.INSTANCE, (ActionRequest)explainRequestFromBody, (ActionListener)listener);
            } else {
                GetDataFrameAnalyticsAction.Request getRequest = new GetDataFrameAnalyticsAction.Request(jobId);
                getRequest.setAllowNoResources(false);
                cancellableClient.execute((ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)getRequest, ActionListener.wrap(getResponse -> {
                    List jobs = getResponse.getResources().results();
                    if (jobs.size() > 1) {
                        listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"expected only one config but matched {}", (Object[])new Object[]{jobs.stream().map(DataFrameAnalyticsConfig::getId).collect(Collectors.toList())}));
                    } else {
                        ExplainDataFrameAnalyticsAction.Request explainRequest = new ExplainDataFrameAnalyticsAction.Request((DataFrameAnalyticsConfig)jobs.get(0));
                        cancellableClient.execute((ActionType)ExplainDataFrameAnalyticsAction.INSTANCE, (ActionRequest)explainRequest, (ActionListener)listener);
                    }
                }, arg_0 -> ((RestToXContentListener)listener).onFailure(arg_0)));
            }
        };
    }
}

