/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

@ServerlessScope(value=Scope.PUBLIC)
public class RestDeleteDatafeedAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.DELETE, (String)("/_ml/datafeeds/{" + String.valueOf(DatafeedConfig.ID) + "}")).replaces(RestRequest.Method.DELETE, "/_xpack/ml/datafeeds/{" + String.valueOf(DatafeedConfig.ID) + "}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_delete_datafeed_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        DeleteDatafeedAction.Request request = new DeleteDatafeedAction.Request(datafeedId);
        if (restRequest.hasParam(DeleteDatafeedAction.Request.FORCE.getPreferredName())) {
            request.setForce(restRequest.paramAsBoolean(CloseJobAction.Request.FORCE.getPreferredName(), request.isForce()));
        }
        request.ackTimeout(RestUtils.getAckTimeout((RestRequest)restRequest));
        request.masterNodeTimeout(RestUtils.getMasterNodeTimeout((RestRequest)restRequest));
        return channel -> client.execute((ActionType)DeleteDatafeedAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

