/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.categorization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.xpack.core.ml.job.config.CategorizationAnalyzerConfig;

public class CategorizationAnalyzer
implements Releasable {
    private final Analyzer analyzer;
    private final boolean closeAnalyzer;

    public CategorizationAnalyzer(AnalysisRegistry analysisRegistry, CategorizationAnalyzerConfig categorizationAnalyzerConfig) throws IOException {
        Tuple<Analyzer, Boolean> tuple = CategorizationAnalyzer.makeAnalyzer(categorizationAnalyzerConfig, analysisRegistry);
        this.analyzer = (Analyzer)tuple.v1();
        this.closeAnalyzer = (Boolean)tuple.v2();
    }

    public CategorizationAnalyzer(Analyzer analyzer, boolean closeAnalyzer) {
        this.analyzer = analyzer;
        this.closeAnalyzer = closeAnalyzer;
    }

    public final TokenStream tokenStream(String fieldName, String text) {
        return this.analyzer.tokenStream(fieldName, text);
    }

    public void close() {
        if (this.closeAnalyzer) {
            this.analyzer.close();
        }
    }

    public List<String> tokenizeField(String fieldName, String fieldValue) {
        ArrayList<String> tokens = new ArrayList<String>();
        try (TokenStream stream = this.analyzer.tokenStream(fieldName, fieldValue);){
            stream.reset();
            CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            while (stream.incrementToken()) {
                String token = term.toString();
                if (token.isEmpty()) continue;
                tokens.add(term.toString());
            }
            stream.end();
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to analyze value [" + fieldValue + "] of field [" + fieldName + "]", (Throwable)e, new Object[0]);
        }
        return tokens;
    }

    public static void verifyConfigBuilder(CategorizationAnalyzerConfig.Builder configBuilder, AnalysisRegistry analysisRegistry) throws IOException {
        Tuple<Analyzer, Boolean> tuple = CategorizationAnalyzer.makeAnalyzer(configBuilder.build(), analysisRegistry);
        if (((Boolean)tuple.v2()).booleanValue()) {
            ((Analyzer)tuple.v1()).close();
        }
    }

    private static Tuple<Analyzer, Boolean> makeAnalyzer(CategorizationAnalyzerConfig config, AnalysisRegistry analysisRegistry) throws IOException {
        String analyzer = config.getAnalyzer();
        if (analyzer != null) {
            Analyzer globalAnalyzer = analysisRegistry.getAnalyzer(analyzer);
            if (globalAnalyzer == null) {
                throw new IllegalArgumentException("Failed to find global analyzer [" + analyzer + "]");
            }
            return new Tuple((Object)globalAnalyzer, (Object)Boolean.FALSE);
        }
        return new Tuple((Object)analysisRegistry.buildCustomAnalyzer(IndexService.IndexCreationContext.RELOAD_ANALYZERS, null, false, config.getTokenizer(), config.getCharFilters(), config.getTokenFilters()), (Object)Boolean.TRUE);
    }
}

