/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.categorization;

import java.util.List;
import org.elasticsearch.xpack.ml.aggs.categorization.TokenListCategory;

public class TokenListSimilarityTester {
    public static int weightedEditDistance(List<TokenListCategory.TokenAndWeight> first, List<TokenListCategory.TokenAndWeight> second) {
        int firstLen = first.size();
        int secondLen = second.size();
        if (firstLen == 0) {
            return second.stream().mapToInt(TokenListCategory.TokenAndWeight::getWeight).sum();
        }
        if (secondLen == 0) {
            return first.stream().mapToInt(TokenListCategory.TokenAndWeight::getWeight).sum();
        }
        int[] currentCol = new int[secondLen + 1];
        int[] prevCol = new int[secondLen + 1];
        currentCol[0] = 0;
        for (int downMinusOne = 0; downMinusOne < secondLen; ++downMinusOne) {
            currentCol[downMinusOne + 1] = currentCol[downMinusOne] + second.get(downMinusOne).getWeight();
        }
        for (TokenListCategory.TokenAndWeight firstTokenAndWeight : first) {
            int[] temp = prevCol;
            prevCol = currentCol;
            currentCol = temp;
            int firstCost = firstTokenAndWeight.getWeight();
            currentCol[0] = prevCol[0] + firstCost;
            for (int downMinusOne = 0; downMinusOne < secondLen; ++downMinusOne) {
                TokenListCategory.TokenAndWeight secondTokenAndWeight = second.get(downMinusOne);
                int secondCost = secondTokenAndWeight.getWeight();
                int option1 = prevCol[downMinusOne + 1] + firstCost;
                int option2 = currentCol[downMinusOne] + secondCost;
                int option3 = prevCol[downMinusOne] + (firstTokenAndWeight.getTokenId() == secondTokenAndWeight.getTokenId() ? 0 : Math.max(firstCost, secondCost));
                currentCol[downMinusOne + 1] = Math.min(Math.min(option1, option2), option3);
            }
        }
        return currentCol[secondLen];
    }
}

