/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.ExpandedIdsMatcher;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.utils.ExceptionCollectionHandling;

public class TransportStopDataFrameAnalyticsAction
extends TransportTasksAction<DataFrameAnalyticsTask, StopDataFrameAnalyticsAction.Request, StopDataFrameAnalyticsAction.Response, StopDataFrameAnalyticsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportStopDataFrameAnalyticsAction.class);
    private final ThreadPool threadPool;
    private final PersistentTasksService persistentTasksService;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final DataFrameAnalyticsAuditor auditor;

    @Inject
    public TransportStopDataFrameAnalyticsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, PersistentTasksService persistentTasksService, DataFrameAnalyticsConfigProvider configProvider, DataFrameAnalyticsAuditor auditor) {
        super("cluster:admin/xpack/ml/data_frame/analytics/stop", clusterService, transportService, actionFilters, StopDataFrameAnalyticsAction.Request::new, StopDataFrameAnalyticsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.persistentTasksService = persistentTasksService;
        this.configProvider = configProvider;
        this.auditor = Objects.requireNonNull(auditor);
    }

    protected void doExecute(Task task, StopDataFrameAnalyticsAction.Request request, ActionListener<StopDataFrameAnalyticsAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            this.redirectToMasterNode(nodes.getMasterNode(), request, listener);
            return;
        }
        logger.debug("Received request to stop data frame analytics [{}]", (Object)request.getId());
        ActionListener expandedIdsListener = ActionListener.wrap(idsToStop -> {
            logger.debug("Resolved data frame analytics to stop: {}", idsToStop);
            PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
            AnalyticsByTaskState analyticsByTaskState = AnalyticsByTaskState.build(idsToStop, tasks);
            if (analyticsByTaskState.isEmpty()) {
                listener.onResponse((Object)new StopDataFrameAnalyticsAction.Response(true));
                return;
            }
            if (request.isForce()) {
                this.forceStop(request, listener, tasks, analyticsByTaskState.getNonStopped());
            } else {
                this.normalStop(task, request, listener, tasks, analyticsByTaskState);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.findIdsToStop(state, request, (ActionListener<Set<String>>)expandedIdsListener);
    }

    private void findIdsToStop(ClusterState clusterState, StopDataFrameAnalyticsAction.Request request, ActionListener<Set<String>> expandedIdsListener) {
        Set<String> startedIds = TransportStopDataFrameAnalyticsAction.getAllStartedIds(clusterState);
        ActionListener matchingIdsListener = ActionListener.wrap(matchingIds -> {
            startedIds.retainAll((Collection<?>)matchingIds);
            expandedIdsListener.onResponse((Object)startedIds);
        }, arg_0 -> expandedIdsListener.onFailure(arg_0));
        if (request.isForce()) {
            this.matchAllStartedIds(request, startedIds, (ActionListener<Set<String>>)matchingIdsListener);
        } else {
            this.configProvider.getMultiple(request.getId(), request.allowNoMatch(), (ActionListener<List<DataFrameAnalyticsConfig>>)ActionListener.wrap(configs -> matchingIdsListener.onResponse(configs.stream().map(DataFrameAnalyticsConfig::getId).collect(Collectors.toSet())), arg_0 -> ((ActionListener)matchingIdsListener).onFailure(arg_0)));
        }
    }

    private static Set<String> getAllStartedIds(ClusterState clusterState) {
        PersistentTasksCustomMetadata tasksMetadata = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks");
        return tasksMetadata == null ? Collections.emptySet() : tasksMetadata.tasks().stream().filter(t -> t.getId().startsWith("data_frame_analytics-")).map(t -> t.getId().replaceFirst("data_frame_analytics-", "")).collect(Collectors.toSet());
    }

    private void matchAllStartedIds(StopDataFrameAnalyticsAction.Request request, Set<String> startedIds, ActionListener<Set<String>> matchingIdsListener) {
        String[] tokens = ExpandedIdsMatcher.tokenizeExpression((String)request.getId());
        ExpandedIdsMatcher expandedIdsMatcher = new ExpandedIdsMatcher(tokens, request.allowNoMatch());
        expandedIdsMatcher.filterMatchedIds(startedIds);
        if (expandedIdsMatcher.hasUnmatchedIds()) {
            this.configProvider.getMultiple(expandedIdsMatcher.unmatchedIdsString(), request.allowNoMatch(), (ActionListener<List<DataFrameAnalyticsConfig>>)ActionListener.wrap(configs -> matchingIdsListener.onResponse((Object)MlStrings.findMatching((String[])tokens, (Set)startedIds)), arg_0 -> matchingIdsListener.onFailure(arg_0)));
        } else {
            matchingIdsListener.onResponse((Object)MlStrings.findMatching((String[])tokens, startedIds));
        }
    }

    private void normalStop(Task task, StopDataFrameAnalyticsAction.Request request, ActionListener<StopDataFrameAnalyticsAction.Response> listener, PersistentTasksCustomMetadata tasks, AnalyticsByTaskState analyticsByTaskState) {
        if (!analyticsByTaskState.failed.isEmpty()) {
            ElasticsearchStatusException e2 = analyticsByTaskState.failed.size() == 1 ? ExceptionsHelper.conflictStatusException((String)"cannot close data frame analytics [{}] because it failed, use force stop instead", (Object[])new Object[]{analyticsByTaskState.failed.iterator().next()}) : ExceptionsHelper.conflictStatusException((String)"one or more data frame analytics are in failed state, use force stop instead", (Object[])new Object[0]);
            listener.onFailure((Exception)e2);
            return;
        }
        request.setExpandedIds(new HashSet<String>(analyticsByTaskState.started));
        request.setNodes(this.findAllocatedNodesAndRemoveUnassignedTasks(analyticsByTaskState.started, tasks));
        Set allAnalyticsToWaitFor = Stream.concat(analyticsByTaskState.started.stream().map(MlTasks::dataFrameAnalyticsTaskId), analyticsByTaskState.stopping.stream().map(MlTasks::dataFrameAnalyticsTaskId)).collect(Collectors.toSet());
        ActionListener finalListener = ActionListener.wrap(r -> this.waitForTaskRemoved(allAnalyticsToWaitFor, request, (StopDataFrameAnalyticsAction.Response)r, listener), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof FailedNodeException) {
                this.doExecute(task, request, listener);
            } else {
                listener.onFailure(e);
            }
        });
        super.doExecute(task, (BaseTasksRequest)request, finalListener);
    }

    private void forceStop(StopDataFrameAnalyticsAction.Request request, ActionListener<StopDataFrameAnalyticsAction.Response> listener, PersistentTasksCustomMetadata tasks, List<String> nonStoppedAnalytics) {
        AtomicInteger counter = new AtomicInteger();
        AtomicArray failures = new AtomicArray(nonStoppedAnalytics.size());
        for (String analyticsId : nonStoppedAnalytics) {
            PersistentTasksCustomMetadata.PersistentTask analyticsTask = MlTasks.getDataFrameAnalyticsTask((String)analyticsId, (PersistentTasksCustomMetadata)tasks);
            if (analyticsTask != null) {
                this.persistentTasksService.sendRemoveRequest(analyticsTask.getId(), MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, ActionListener.wrap(removedTask -> {
                    this.auditor.info(analyticsId, "Stopped analytics (forced)");
                    if (counter.incrementAndGet() == nonStoppedAnalytics.size()) {
                        TransportStopDataFrameAnalyticsAction.sendResponseOrFailure(request.getId(), listener, (AtomicArray<Exception>)failures);
                    }
                }, e -> {
                    int slot = counter.incrementAndGet();
                    if (!(ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException)) {
                        failures.set(slot - 1, e);
                    }
                    if (slot == nonStoppedAnalytics.size()) {
                        TransportStopDataFrameAnalyticsAction.sendResponseOrFailure(request.getId(), listener, (AtomicArray<Exception>)failures);
                    }
                }));
                continue;
            }
            String msg = "Requested data frame analytics [" + analyticsId + "] be force-stopped, but no task could be found.";
            assert (analyticsTask != null) : msg;
            logger.error(msg);
            int slot = counter.incrementAndGet();
            failures.set(slot - 1, (Object)new RuntimeException(msg));
            if (slot != nonStoppedAnalytics.size()) continue;
            TransportStopDataFrameAnalyticsAction.sendResponseOrFailure(request.getId(), listener, (AtomicArray<Exception>)failures);
        }
    }

    private static void sendResponseOrFailure(String analyticsId, ActionListener<StopDataFrameAnalyticsAction.Response> listener, AtomicArray<Exception> failures) {
        List caughtExceptions = failures.asList();
        if (caughtExceptions.isEmpty()) {
            listener.onResponse((Object)new StopDataFrameAnalyticsAction.Response(true));
            return;
        }
        String msg = "Failed to stop data frame analytics [" + analyticsId + "] with [" + caughtExceptions.size() + "] failures, rethrowing first. All Exceptions: [" + caughtExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", ")) + "]";
        ElasticsearchStatusException e = ExceptionCollectionHandling.exceptionArrayToStatusException(failures, msg);
        listener.onFailure((Exception)e);
    }

    private String[] findAllocatedNodesAndRemoveUnassignedTasks(List<String> analyticsIds, PersistentTasksCustomMetadata tasks) {
        ArrayList<String> nodes = new ArrayList<String>();
        for (String analyticsId : analyticsIds) {
            PersistentTasksCustomMetadata.PersistentTask task = MlTasks.getDataFrameAnalyticsTask((String)analyticsId, (PersistentTasksCustomMetadata)tasks);
            if (task == null) {
                String msg = "Requested data frame analytics [" + analyticsId + "] be stopped but the task could not be found";
                assert (task != null) : msg;
                continue;
            }
            if (task.isAssigned()) {
                nodes.add(task.getExecutorNode());
                continue;
            }
            this.persistentTasksService.sendRemoveRequest(task.getId(), MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, ActionListener.noop());
        }
        return nodes.toArray(new String[0]);
    }

    private void redirectToMasterNode(DiscoveryNode masterNode, StopDataFrameAnalyticsAction.Request request, ActionListener<StopDataFrameAnalyticsAction.Response> listener) {
        if (masterNode == null) {
            listener.onFailure((Exception)new MasterNotDiscoveredException());
        } else {
            this.transportService.sendRequest(masterNode, this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, StopDataFrameAnalyticsAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
        }
    }

    protected StopDataFrameAnalyticsAction.Response newResponse(StopDataFrameAnalyticsAction.Request request, List<StopDataFrameAnalyticsAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (request.getExpandedIds().size() != tasks.size()) {
            if (!taskOperationFailures.isEmpty()) {
                throw ExceptionsHelper.taskOperationFailureToStatusException((TaskOperationFailure)taskOperationFailures.get(0));
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw failedNodeExceptions.get(0);
            }
            return new StopDataFrameAnalyticsAction.Response(true);
        }
        return new StopDataFrameAnalyticsAction.Response(tasks.stream().allMatch(StopDataFrameAnalyticsAction.Response::isStopped));
    }

    protected void taskOperation(CancellableTask actionTask, final StopDataFrameAnalyticsAction.Request request, final DataFrameAnalyticsTask task, final ActionListener<StopDataFrameAnalyticsAction.Response> listener) {
        DataFrameAnalyticsTaskState stoppingState = new DataFrameAnalyticsTaskState(DataFrameAnalyticsState.STOPPING, task.getAllocationId(), null, Instant.now());
        task.updatePersistentTaskState((PersistentTaskState)stoppingState, ActionListener.wrap(pTask -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            protected void doRun() {
                logger.info("[{}] Stopping task with force [{}]", (Object)task.getParams().getId(), (Object)request.isForce());
                task.stop("stop_data_frame_analytics (api)", request.getTimeout());
                listener.onResponse((Object)new StopDataFrameAnalyticsAction.Response(true));
            }
        }), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                listener.onResponse((Object)new StopDataFrameAnalyticsAction.Response(true));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    void waitForTaskRemoved(Set<String> taskIds, StopDataFrameAnalyticsAction.Request request, StopDataFrameAnalyticsAction.Response response, ActionListener<StopDataFrameAnalyticsAction.Response> listener) {
        this.persistentTasksService.waitForPersistentTasksCondition(persistentTasks -> persistentTasks.findTasks("xpack/ml/data_frame/analytics", t -> taskIds.contains(t.getId())).isEmpty(), request.getTimeout(), ActionListener.wrap(booleanResponse -> {
            this.auditor.info(request.getId(), "Stopped analytics");
            listener.onResponse((Object)response);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static class AnalyticsByTaskState {
        final List<String> started;
        final List<String> stopping;
        final List<String> failed;

        private AnalyticsByTaskState(List<String> started, List<String> stopping, List<String> failed) {
            this.started = Collections.unmodifiableList(started);
            this.stopping = Collections.unmodifiableList(stopping);
            this.failed = Collections.unmodifiableList(failed);
        }

        boolean isEmpty() {
            return this.started.isEmpty() && this.stopping.isEmpty() && this.failed.isEmpty();
        }

        List<String> getNonStopped() {
            ArrayList<String> nonStopped = new ArrayList<String>();
            nonStopped.addAll(this.started);
            nonStopped.addAll(this.stopping);
            nonStopped.addAll(this.failed);
            return nonStopped;
        }

        static AnalyticsByTaskState build(Set<String> analyticsIds, PersistentTasksCustomMetadata tasks) {
            ArrayList<String> started = new ArrayList<String>();
            ArrayList<String> stopping = new ArrayList<String>();
            ArrayList<String> failed = new ArrayList<String>();
            block6: for (String analyticsId : analyticsIds) {
                DataFrameAnalyticsState taskState = MlTasks.getDataFrameAnalyticsState((String)analyticsId, (PersistentTasksCustomMetadata)tasks);
                switch (taskState) {
                    case STARTING: 
                    case STARTED: 
                    case REINDEXING: 
                    case ANALYZING: {
                        started.add(analyticsId);
                        continue block6;
                    }
                    case STOPPING: {
                        stopping.add(analyticsId);
                        continue block6;
                    }
                    case STOPPED: {
                        continue block6;
                    }
                    case FAILED: {
                        failed.add(analyticsId);
                        continue block6;
                    }
                }
                assert (false) : "unknown task state " + String.valueOf(taskState);
            }
            return new AnalyticsByTaskState(started, stopping, failed);
        }
    }
}

