/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.history;

import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class ILMHistoryTemplateRegistry
extends IndexTemplateRegistry {
    public static final int INDEX_TEMPLATE_VERSION = 7;
    public static final NodeFeature MANAGED_BY_DATA_STREAM_LIFECYCLE = new NodeFeature("ilm-history-managed-by-dsl");
    public static final String ILM_TEMPLATE_VERSION_VARIABLE = "xpack.ilm_history.template.version";
    public static final String ILM_TEMPLATE_NAME = "ilm-history-7";
    public static final String ILM_POLICY_NAME = "ilm-history-ilm-policy";
    private final FeatureService featureService;
    private final boolean ilmHistoryEnabled;
    private static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATE_CONFIGS = ILMHistoryTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig("ilm-history-7", "/ilm-history.json", 7, "xpack.ilm_history.template.version")});
    private static final LifecyclePolicyConfig LIFECYCLE_POLICY_CONFIG = new LifecyclePolicyConfig("ilm-history-ilm-policy", "/ilm-history-ilm-policy.json");

    protected boolean requiresMasterNode() {
        return true;
    }

    public ILMHistoryTemplateRegistry(Settings nodeSettings, ClusterService clusterService, FeatureService featureService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.featureService = featureService;
        this.ilmHistoryEnabled = (Boolean)LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING.get(nodeSettings);
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        if (this.ilmHistoryEnabled) {
            return COMPOSABLE_INDEX_TEMPLATE_CONFIGS;
        }
        return Map.of();
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        return List.of(LIFECYCLE_POLICY_CONFIG);
    }

    protected List<LifecyclePolicy> getLifecyclePolicies() {
        if (this.ilmHistoryEnabled) {
            return this.lifecyclePolicies;
        }
        return List.of();
    }

    protected String getOrigin() {
        return "index_lifecycle";
    }

    protected boolean isClusterReady(ClusterChangedEvent event) {
        return this.featureService.clusterHasFeature(event.state(), MANAGED_BY_DATA_STREAM_LIFECYCLE);
    }
}

