/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;

public class DataStreamDeprecationChecks {
    static DeprecationIssue oldIndicesCheck(DataStream dataStream, ClusterState clusterState) {
        List backingIndices = dataStream.getIndices();
        boolean hasOldIndices = backingIndices.stream().anyMatch(index -> clusterState.metadata().index(index).getCompatibilityVersion().before((VersionId)IndexVersions.V_8_0_0));
        if (hasOldIndices) {
            long totalIndices = backingIndices.size();
            List<Index> oldIndices = backingIndices.stream().filter(index -> clusterState.metadata().index(index).getCompatibilityVersion().before((VersionId)IndexVersions.V_8_0_0)).toList();
            long totalOldIndices = oldIndices.size();
            long totalOldSearchableSnapshots = oldIndices.stream().filter(index -> clusterState.metadata().index(index).isSearchableSnapshot()).count();
            long totalOldPartiallyMountedSearchableSnapshots = oldIndices.stream().filter(index -> clusterState.metadata().index(index).isPartialSearchableSnapshot()).count();
            long totalOldFullyMountedSearchableSnapshots = totalOldSearchableSnapshots - totalOldPartiallyMountedSearchableSnapshots;
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Old data stream with a compatibility version < 8.0", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-9.0.html", "This data stream has backing indices that were created before Elasticsearch 8.0.0", false, Map.ofEntries(Map.entry("backing_indices", Map.ofEntries(Map.entry("count", totalIndices), Map.entry("need_upgrading", Map.ofEntries(Map.entry("count", totalOldIndices), Map.entry("searchable_snapshots", Map.ofEntries(Map.entry("count", totalOldSearchableSnapshots), Map.entry("fully_mounted", Map.ofEntries(Map.entry("count", totalOldFullyMountedSearchableSnapshots))), Map.entry("partially_mounted", Map.ofEntries(Map.entry("count", totalOldPartiallyMountedSearchableSnapshots)))))))))));
        }
        return null;
    }
}

