/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalValueCount;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

public final class HistoBackedValueCountAggregator
extends NumericMetricsAggregator.SingleValue {
    final HistogramValuesSource.Histogram valuesSource;
    LongArray counts;

    public HistoBackedValueCountAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, aggregationContext, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (HistogramValuesSource.Histogram)valuesSourceConfig.getValuesSource();
        this.counts = this.bigArrays().newLongArray(1L, true);
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final HistogramValues values = this.valuesSource.getHistogramValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                HistoBackedValueCountAggregator.this.counts = HistoBackedValueCountAggregator.this.bigArrays().grow(HistoBackedValueCountAggregator.this.counts, bucket + 1L);
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    while (sketch.next()) {
                        HistoBackedValueCountAggregator.this.counts.increment(bucket, sketch.count());
                    }
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        return owningBucketOrd >= this.counts.size() ? 0.0 : (double)this.counts.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalValueCount(this.name, this.counts.get(bucket), this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return InternalValueCount.empty((String)this.name, (Map)this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable)this.counts);
    }
}

