/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ibmwatsonx;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.EmptySettingsConfiguration;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskSettingsConfiguration;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.chunking.EmbeddingRequestChunker;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.ibmwatsonx.IbmWatsonxActionCreator;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.IbmWatsonxModel;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.embeddings.IbmWatsonxEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.embeddings.IbmWatsonxEmbeddingsServiceSettings;

public class IbmWatsonxService
extends SenderService {
    public static final String NAME = "watsonxai";
    private static final EnumSet<TaskType> supportedTaskTypes = EnumSet.of(TaskType.TEXT_EMBEDDING);

    public IbmWatsonxService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents) {
        super(factory, serviceComponents);
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            IbmWatsonxModel model = IbmWatsonxService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, serviceSettingsMap, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IbmWatsonxModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secretSettings, String failureMessage, ConfigurationParseContext context) {
        switch (taskType) {
            case TEXT_EMBEDDING: {
                return new IbmWatsonxEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
            }
            default: {
                throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
    }

    public IbmWatsonxModel parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(secrets, "secret_settings");
        return IbmWatsonxService.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public InferenceServiceConfiguration getConfiguration() {
        return Configuration.get();
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return supportedTaskTypes;
    }

    private static IbmWatsonxModel createModelFromPersistent(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, Map<String, Object> secretSettings, String failureMessage) {
        return IbmWatsonxService.createModel(inferenceEntityId, taskType, serviceSettings, taskSettings, secretSettings, failureMessage, ConfigurationParseContext.PERSISTENT);
    }

    public Model parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        return IbmWatsonxService.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, null, ServiceUtils.parsePersistedConfigErrorMsg(inferenceEntityId, NAME));
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_IBM_WATSONX_EMBEDDINGS_ADDED;
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        if (model instanceof IbmWatsonxEmbeddingsModel) {
            IbmWatsonxEmbeddingsModel embeddingsModel = (IbmWatsonxEmbeddingsModel)model;
            ServiceUtils.getEmbeddingSize(model, this, (ActionListener<Integer>)listener.delegateFailureAndWrap((l, size) -> l.onResponse((Object)this.updateModelWithEmbeddingDetails(embeddingsModel, (int)size))));
        } else {
            listener.onResponse((Object)model);
        }
    }

    private IbmWatsonxEmbeddingsModel updateModelWithEmbeddingDetails(IbmWatsonxEmbeddingsModel model, int embeddingSize) {
        SimilarityMeasure similarityFromModel = model.getServiceSettings().similarity();
        SimilarityMeasure similarityToUse = similarityFromModel == null ? SimilarityMeasure.DOT_PRODUCT : similarityFromModel;
        IbmWatsonxEmbeddingsServiceSettings serviceSettings = new IbmWatsonxEmbeddingsServiceSettings(model.getServiceSettings().modelId(), model.getServiceSettings().projectId(), model.getServiceSettings().url(), model.getServiceSettings().apiVersion(), model.getServiceSettings().maxInputTokens(), embeddingSize, similarityToUse, model.getServiceSettings().rateLimitSettings());
        return new IbmWatsonxEmbeddingsModel(model, serviceSettings);
    }

    @Override
    protected void doInfer(Model model, InferenceInputs input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof IbmWatsonxModel)) {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
            return;
        }
        IbmWatsonxModel ibmWatsonxModel = (IbmWatsonxModel)model;
        ExecutableAction action = ibmWatsonxModel.accept(this.getActionCreator(this.getSender(), this.getServiceComponents()), taskSettings, inputType);
        action.execute(input, timeout, listener);
    }

    @Override
    protected void doChunkedInfer(Model model, DocumentsOnlyInput input, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        IbmWatsonxModel ibmWatsonxModel = (IbmWatsonxModel)model;
        List<EmbeddingRequestChunker.BatchRequestAndListener> batchedRequests = new EmbeddingRequestChunker(input.getInputs(), 1000, EmbeddingRequestChunker.EmbeddingType.FLOAT).batchRequestsWithListeners(listener);
        for (EmbeddingRequestChunker.BatchRequestAndListener request : batchedRequests) {
            ExecutableAction action = ibmWatsonxModel.accept(this.getActionCreator(this.getSender(), this.getServiceComponents()), taskSettings, inputType);
            action.execute(new DocumentsOnlyInput(request.batch().inputs()), timeout, request.listener());
        }
    }

    protected IbmWatsonxActionCreator getActionCreator(Sender sender, ServiceComponents serviceComponents) {
        return new IbmWatsonxActionCreator(this.getSender(), this.getServiceComponents());
    }

    public static class Configuration {
        private static final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("api_version", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("API Version").setOrder(Integer.valueOf(1)).setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setTooltip("The IBM Watsonx API version ID to use.").setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("project_id", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("Project ID").setOrder(Integer.valueOf(2)).setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setTooltip("").setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("model_id", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("Model ID").setOrder(Integer.valueOf(3)).setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setTooltip("The name of the model to use for the inference task.").setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("url", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("URL").setOrder(Integer.valueOf(4)).setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setTooltip("").setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("max_input_tokens", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.NUMERIC).setLabel("Maximum Input Tokens").setOrder(Integer.valueOf(5)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Allows you to specify the maximum number of tokens per input.").setType(SettingsConfigurationFieldType.INTEGER).build());
            return new InferenceServiceConfiguration.Builder().setProvider(IbmWatsonxService.NAME).setTaskTypes(supportedTaskTypes.stream().map(t -> {
                switch (t) {
                    default: 
                }
                Map taskSettingsConfig = EmptySettingsConfiguration.get();
                return new TaskSettingsConfiguration.Builder().setTaskType(t).setConfiguration(taskSettingsConfig).build();
            }).toList()).setConfiguration(configurationMap).build();
        });

        public static InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)configuration.getOrCompute();
        }
    }
}

