/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.embeddings;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.inference.configuration.SettingsConfigurationSelectOption;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.googlevertexai.GoogleVertexAiActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiSecretSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsRequestTaskSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsTaskSettings;

public class GoogleVertexAiEmbeddingsModel
extends GoogleVertexAiModel {
    public static GoogleVertexAiEmbeddingsModel of(GoogleVertexAiEmbeddingsModel model, Map<String, Object> taskSettings, InputType inputType) {
        GoogleVertexAiEmbeddingsRequestTaskSettings requestTaskSettings = GoogleVertexAiEmbeddingsRequestTaskSettings.fromMap(taskSettings);
        return new GoogleVertexAiEmbeddingsModel(model, GoogleVertexAiEmbeddingsTaskSettings.of(model.getTaskSettings(), requestTaskSettings, inputType));
    }

    public GoogleVertexAiEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, GoogleVertexAiEmbeddingsServiceSettings.fromMap(serviceSettings, context), GoogleVertexAiEmbeddingsTaskSettings.fromMap(taskSettings), chunkingSettings, GoogleVertexAiSecretSettings.fromMap(secrets));
    }

    public GoogleVertexAiEmbeddingsModel(GoogleVertexAiEmbeddingsModel model, GoogleVertexAiEmbeddingsServiceSettings serviceSettings) {
        super((GoogleVertexAiModel)model, serviceSettings);
    }

    public GoogleVertexAiEmbeddingsModel(GoogleVertexAiEmbeddingsModel model, GoogleVertexAiEmbeddingsTaskSettings taskSettings) {
        super((GoogleVertexAiModel)model, taskSettings);
    }

    GoogleVertexAiEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, GoogleVertexAiEmbeddingsServiceSettings serviceSettings, GoogleVertexAiEmbeddingsTaskSettings taskSettings, ChunkingSettings chunkingSettings, @Nullable GoogleVertexAiSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings, chunkingSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
        try {
            this.uri = GoogleVertexAiEmbeddingsModel.buildUri(serviceSettings.location(), serviceSettings.projectId(), serviceSettings.modelId());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected GoogleVertexAiEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, String uri, GoogleVertexAiEmbeddingsServiceSettings serviceSettings, GoogleVertexAiEmbeddingsTaskSettings taskSettings, @Nullable GoogleVertexAiSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public GoogleVertexAiEmbeddingsServiceSettings getServiceSettings() {
        return (GoogleVertexAiEmbeddingsServiceSettings)super.getServiceSettings();
    }

    public GoogleVertexAiEmbeddingsTaskSettings getTaskSettings() {
        return (GoogleVertexAiEmbeddingsTaskSettings)super.getTaskSettings();
    }

    public GoogleVertexAiSecretSettings getSecretSettings() {
        return (GoogleVertexAiSecretSettings)super.getSecretSettings();
    }

    @Override
    public GoogleVertexAiEmbeddingsRateLimitServiceSettings rateLimitServiceSettings() {
        return (GoogleVertexAiEmbeddingsRateLimitServiceSettings)super.rateLimitServiceSettings();
    }

    @Override
    public ExecutableAction accept(GoogleVertexAiActionVisitor visitor, Map<String, Object> taskSettings, InputType inputType) {
        return visitor.create(this, taskSettings, inputType);
    }

    public static URI buildUri(String location, String projectId, String modelId) throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost(Strings.format((String)"%s%s", (Object[])new Object[]{location, "-aiplatform.googleapis.com"})).setPathSegments(new String[]{"v1", "projects", projectId, "locations", location, "publishers", "google", "models", Strings.format((String)"%s:%s", (Object[])new Object[]{modelId, "predict"})}).build();
    }

    public static class Configuration {
        private static final LazyInitializable<Map<String, SettingsConfiguration>, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("input_type", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.DROPDOWN).setLabel("Input Type").setOrder(Integer.valueOf(1)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Specifies the type of input passed to the model.").setType(SettingsConfigurationFieldType.STRING).setOptions(Stream.of(InputType.CLASSIFICATION.toString(), InputType.CLUSTERING.toString(), InputType.INGEST.toString(), InputType.SEARCH.toString()).map(v -> new SettingsConfigurationSelectOption.Builder().setLabelAndValue(v).build()).toList()).setValue((Object)"").build());
            configurationMap.put("auto_truncate", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TOGGLE).setLabel("Auto Truncate").setOrder(Integer.valueOf(2)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Specifies if the API truncates inputs longer than the maximum token length automatically.").setType(SettingsConfigurationFieldType.BOOLEAN).setValue((Object)false).build());
            return Collections.unmodifiableMap(configurationMap);
        });

        public static Map<String, SettingsConfiguration> get() {
            return (Map)configuration.getOrCompute();
        }
    }
}

