/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.anthropic.completion;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionRequestTaskSettings;

public class AnthropicChatCompletionTaskSettings
implements TaskSettings {
    public static final String NAME = "anthropic_completion_task_settings";
    private final int maxTokens;
    private final Double temperature;
    private final Double topP;
    private final Integer topK;

    public static AnthropicChatCompletionTaskSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ConfigurationParseContext.REQUEST -> AnthropicChatCompletionTaskSettings.fromRequestMap(map);
            case ConfigurationParseContext.PERSISTENT -> AnthropicChatCompletionTaskSettings.fromPersistedMap(map);
        };
    }

    private static AnthropicChatCompletionTaskSettings fromRequestMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        CommonFields commonFields = AnthropicChatCompletionTaskSettings.fromMap(map, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AnthropicChatCompletionTaskSettings(commonFields);
    }

    private static AnthropicChatCompletionTaskSettings fromPersistedMap(Map<String, Object> map) {
        CommonFields commonFields = AnthropicChatCompletionTaskSettings.fromMap(map, new ValidationException());
        return new AnthropicChatCompletionTaskSettings(commonFields);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        return AnthropicChatCompletionTaskSettings.fromRequestMap(new HashMap<String, Object>(newSettings));
    }

    private static CommonFields fromMap(Map<String, Object> map, ValidationException validationException) {
        Integer maxTokens = ServiceUtils.extractRequiredPositiveInteger(map, "max_tokens", "task_settings", validationException);
        Double temperature = ServiceUtils.removeAsType(map, "temperature", Double.class);
        Double topP = ServiceUtils.removeAsType(map, "top_p", Double.class);
        Integer topK = ServiceUtils.removeAsType(map, "top_k", Integer.class);
        return new CommonFields(Objects.requireNonNullElse(maxTokens, -1), temperature, topP, topK);
    }

    public static AnthropicChatCompletionTaskSettings of(AnthropicChatCompletionTaskSettings originalSettings, AnthropicChatCompletionRequestTaskSettings requestSettings) {
        return new AnthropicChatCompletionTaskSettings(Objects.requireNonNullElse(requestSettings.maxTokens(), originalSettings.maxTokens), ServiceUtils.nonNullOrDefault(requestSettings.temperature(), originalSettings.temperature), ServiceUtils.nonNullOrDefault(requestSettings.topP(), originalSettings.topP), ServiceUtils.nonNullOrDefault(requestSettings.topK(), originalSettings.topK));
    }

    public AnthropicChatCompletionTaskSettings(int maxTokens, @Nullable Double temperature, @Nullable Double topP, @Nullable Integer topK) {
        this.maxTokens = maxTokens;
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
    }

    public AnthropicChatCompletionTaskSettings(StreamInput in) throws IOException {
        this.maxTokens = in.readVInt();
        this.temperature = in.readOptionalDouble();
        this.topP = in.readOptionalDouble();
        this.topK = in.readOptionalInt();
    }

    private AnthropicChatCompletionTaskSettings(CommonFields commonFields) {
        this(commonFields.maxTokens, commonFields.temperature, commonFields.topP, commonFields.topK);
    }

    public int maxTokens() {
        return this.maxTokens;
    }

    public Double temperature() {
        return this.temperature;
    }

    public Double topP() {
        return this.topP;
    }

    public Integer topK() {
        return this.topK;
    }

    public boolean isEmpty() {
        return false;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("max_tokens", this.maxTokens);
        if (this.temperature != null) {
            builder.field("temperature", this.temperature);
        }
        if (this.topP != null) {
            builder.field("top_p", this.topP);
        }
        if (this.topK != null) {
            builder.field("top_p", this.topK);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.maxTokens);
        out.writeOptionalDouble(this.temperature);
        out.writeOptionalDouble(this.topP);
        out.writeOptionalInt(this.topK);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AnthropicChatCompletionTaskSettings that = (AnthropicChatCompletionTaskSettings)object;
        return Objects.equals(this.maxTokens, that.maxTokens) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topP, that.topP) && Objects.equals(this.topK, that.topK);
    }

    public int hashCode() {
        return Objects.hash(this.maxTokens, this.temperature, this.topP, this.topK);
    }

    private record CommonFields(int maxTokens, Double temperature, Double topP, Integer topK) {
    }
}

