/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock;

import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.EmptySettingsConfiguration;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskSettingsConfiguration;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.inference.configuration.SettingsConfigurationSelectOption;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.chunking.ChunkingSettingsBuilder;
import org.elasticsearch.xpack.inference.chunking.EmbeddingRequestChunker;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.amazonbedrock.AmazonBedrockActionCreator;
import org.elasticsearch.xpack.inference.external.amazonbedrock.AmazonBedrockRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockProvider;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockProviderCapabilities;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockSecretSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class AmazonBedrockService
extends SenderService {
    public static final String NAME = "amazonbedrock";
    private final Sender amazonBedrockSender;
    private static final EnumSet<TaskType> supportedTaskTypes = EnumSet.of(TaskType.TEXT_EMBEDDING, TaskType.COMPLETION);

    public AmazonBedrockService(HttpRequestSender.Factory httpSenderFactory, AmazonBedrockRequestSender.Factory amazonBedrockFactory, ServiceComponents serviceComponents) {
        super(httpSenderFactory, serviceComponents);
        this.amazonBedrockSender = amazonBedrockFactory.createSender();
    }

    @Override
    protected void doInfer(Model model, InferenceInputs inputs, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        AmazonBedrockActionCreator actionCreator = new AmazonBedrockActionCreator(this.amazonBedrockSender, this.getServiceComponents(), timeout);
        if (model instanceof AmazonBedrockModel) {
            AmazonBedrockModel baseAmazonBedrockModel = (AmazonBedrockModel)model;
            ExecutableAction action = baseAmazonBedrockModel.accept(actionCreator, taskSettings);
            action.execute(inputs, timeout, listener);
        } else {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
        }
    }

    @Override
    protected void doChunkedInfer(Model model, DocumentsOnlyInput inputs, Map<String, Object> taskSettings, InputType inputType, ChunkingOptions chunkingOptions, TimeValue timeout, ActionListener<List<ChunkedInferenceServiceResults>> listener) {
        AmazonBedrockActionCreator actionCreator = new AmazonBedrockActionCreator(this.amazonBedrockSender, this.getServiceComponents(), timeout);
        if (model instanceof AmazonBedrockModel) {
            AmazonBedrockModel baseAmazonBedrockModel = (AmazonBedrockModel)model;
            int maxBatchSize = AmazonBedrockProviderCapabilities.getEmbeddingsMaxBatchSize(baseAmazonBedrockModel.provider());
            List<EmbeddingRequestChunker.BatchRequestAndListener> batchedRequests = new EmbeddingRequestChunker(inputs.getInputs(), maxBatchSize, EmbeddingRequestChunker.EmbeddingType.FLOAT, baseAmazonBedrockModel.getConfigurations().getChunkingSettings()).batchRequestsWithListeners(listener);
            for (EmbeddingRequestChunker.BatchRequestAndListener request : batchedRequests) {
                ExecutableAction action = baseAmazonBedrockModel.accept(actionCreator, taskSettings);
                action.execute(new DocumentsOnlyInput(request.batch().inputs()), timeout, request.listener());
            }
        } else {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
        }
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String modelId, TaskType taskType, Map<String, Object> config, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            ChunkingSettings chunkingSettings = null;
            if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
                chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMapOrDefaultEmpty(config, "chunking_settings"));
            }
            AmazonBedrockModel model = AmazonBedrockService.createModel(modelId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, serviceSettingsMap, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    public Model parsePersistedConfigWithSecrets(String modelId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(secrets, "secret_settings");
        ChunkingSettings chunkingSettings = null;
        if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMap(config, "chunking_settings"));
        }
        return AmazonBedrockService.createModel(modelId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(modelId, NAME), ConfigurationParseContext.PERSISTENT);
    }

    public Model parsePersistedConfig(String modelId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        ChunkingSettings chunkingSettings = null;
        if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMap(config, "chunking_settings"));
        }
        return AmazonBedrockService.createModel(modelId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, null, ServiceUtils.parsePersistedConfigErrorMsg(modelId, NAME), ConfigurationParseContext.PERSISTENT);
    }

    public InferenceServiceConfiguration getConfiguration() {
        return Configuration.get();
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return supportedTaskTypes;
    }

    private static AmazonBedrockModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secretSettings, String failureMessage, ConfigurationParseContext context) {
        switch (taskType) {
            case TEXT_EMBEDDING: {
                AmazonBedrockEmbeddingsModel model = new AmazonBedrockEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, chunkingSettings, secretSettings, context);
                AmazonBedrockService.checkProviderForTask(TaskType.TEXT_EMBEDDING, model.provider());
                return model;
            }
            case COMPLETION: {
                AmazonBedrockChatCompletionModel model = new AmazonBedrockChatCompletionModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
                AmazonBedrockService.checkProviderForTask(TaskType.COMPLETION, model.provider());
                AmazonBedrockService.checkChatCompletionProviderForTopKParameter(model);
                return model;
            }
        }
        throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public Set<TaskType> supportedStreamingTasks() {
        return COMPLETION_ONLY;
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        if (model instanceof AmazonBedrockEmbeddingsModel) {
            AmazonBedrockEmbeddingsModel embeddingsModel = (AmazonBedrockEmbeddingsModel)model;
            ServiceUtils.getEmbeddingSize(model, this, (ActionListener<Integer>)listener.delegateFailureAndWrap((l, size) -> l.onResponse((Object)this.updateModelWithEmbeddingDetails(embeddingsModel, (int)size))));
        } else {
            listener.onResponse((Object)model);
        }
    }

    private AmazonBedrockEmbeddingsModel updateModelWithEmbeddingDetails(AmazonBedrockEmbeddingsModel model, int embeddingSize) {
        AmazonBedrockEmbeddingsServiceSettings serviceSettings = model.getServiceSettings();
        if (serviceSettings.dimensionsSetByUser().booleanValue() && serviceSettings.dimensions() != null && serviceSettings.dimensions() != embeddingSize) {
            throw new ElasticsearchStatusException(Strings.format((String)"The retrieved embeddings size [%s] does not match the size specified in the settings [%s]. Please recreate the [%s] configuration with the correct dimensions", (Object[])new Object[]{embeddingSize, serviceSettings.dimensions(), model.getConfigurations().getInferenceEntityId()}), RestStatus.BAD_REQUEST, new Object[0]);
        }
        SimilarityMeasure similarityFromModel = serviceSettings.similarity();
        SimilarityMeasure similarityToUse = similarityFromModel == null ? AmazonBedrockProviderCapabilities.getProviderDefaultSimilarityMeasure(model.provider()) : similarityFromModel;
        AmazonBedrockEmbeddingsServiceSettings settingsToUse = new AmazonBedrockEmbeddingsServiceSettings(serviceSettings.region(), serviceSettings.modelId(), serviceSettings.provider(), embeddingSize, serviceSettings.dimensionsSetByUser(), serviceSettings.maxInputTokens(), similarityToUse, serviceSettings.rateLimitSettings());
        return new AmazonBedrockEmbeddingsModel((Model)model, settingsToUse);
    }

    private static void checkProviderForTask(TaskType taskType, AmazonBedrockProvider provider) {
        if (!AmazonBedrockProviderCapabilities.providerAllowsTaskType(provider, taskType)) {
            throw new ElasticsearchStatusException(Strings.format((String)"The [%s] task type for provider [%s] is not available", (Object[])new Object[]{taskType, provider}), RestStatus.BAD_REQUEST, new Object[0]);
        }
    }

    private static void checkChatCompletionProviderForTopKParameter(AmazonBedrockChatCompletionModel model) {
        AmazonBedrockChatCompletionTaskSettings taskSettings = model.getTaskSettings();
        if (taskSettings.topK() != null && !AmazonBedrockProviderCapabilities.chatCompletionProviderHasTopKParameter(model.provider())) {
            throw new ElasticsearchStatusException(Strings.format((String)"The [%s] task parameter is not available for provider [%s]", (Object[])new Object[]{"top_k", model.provider()}), RestStatus.BAD_REQUEST, new Object[0]);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        IOUtils.closeWhileHandlingException((Closeable)this.amazonBedrockSender);
    }

    public static class Configuration {
        private static final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("provider", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.DROPDOWN).setLabel("Provider").setOrder(Integer.valueOf(3)).setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setTooltip("The model provider for your deployment.").setType(SettingsConfigurationFieldType.STRING).setOptions(Stream.of("amazontitan", "anthropic", "ai21labs", "cohere", "meta", "mistral").map(v -> new SettingsConfigurationSelectOption.Builder().setLabelAndValue(v).build()).toList()).build());
            configurationMap.put("model", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("Model").setOrder(Integer.valueOf(4)).setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setTooltip("The base model ID or an ARN to a custom model based on a foundational model.").setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("region", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("Region").setOrder(Integer.valueOf(5)).setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setTooltip("The region that your model or ARN is deployed in.").setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.putAll(AmazonBedrockSecretSettings.Configuration.get());
            configurationMap.putAll(RateLimitSettings.toSettingsConfigurationWithTooltip("By default, the amazonbedrock service sets the number of requests allowed per minute to 240."));
            return new InferenceServiceConfiguration.Builder().setProvider(AmazonBedrockService.NAME).setTaskTypes(supportedTaskTypes.stream().map(t -> new TaskSettingsConfiguration.Builder().setTaskType(t).setConfiguration(switch (t) {
                case TaskType.COMPLETION -> AmazonBedrockChatCompletionModel.Configuration.get();
                default -> EmptySettingsConfiguration.get();
            }).build()).toList()).setConfiguration(configurationMap).build();
        });

        public static InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)configuration.getOrCompute();
        }
    }
}

