/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.cluster.metadata.InferenceFieldMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InferenceFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.SparseVectorFieldMapper;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.search.vectors.KnnVectorQueryBuilder;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.inference.results.MlTextEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.TextExpansionResults;
import org.elasticsearch.xpack.core.ml.search.WeightedToken;
import org.elasticsearch.xpack.inference.mapper.SemanticTextField;

public class SemanticTextFieldMapper
extends FieldMapper
implements InferenceFieldMapper {
    public static final NodeFeature SEMANTIC_TEXT_SEARCH_INFERENCE_ID = new NodeFeature("semantic_text.search_inference_id");
    public static final NodeFeature SEMANTIC_TEXT_DEFAULT_ELSER_2 = new NodeFeature("semantic_text.default_elser_2");
    public static final NodeFeature SEMANTIC_TEXT_IN_OBJECT_FIELD_FIX = new NodeFeature("semantic_text.in_object_field_fix");
    public static final NodeFeature SEMANTIC_TEXT_SINGLE_FIELD_UPDATE_FIX = new NodeFeature("semantic_text.single_field_update_fix");
    public static final NodeFeature SEMANTIC_TEXT_DELETE_FIX = new NodeFeature("semantic_text.delete_fix");
    public static final NodeFeature SEMANTIC_TEXT_ZERO_SIZE_FIX = new NodeFeature("semantic_text.zero_size_fix");
    public static final NodeFeature SEMANTIC_TEXT_ALWAYS_EMIT_INFERENCE_ID_FIX = new NodeFeature("semantic_text.always_emit_inference_id_fix");
    public static final String CONTENT_TYPE = "semantic_text";
    public static final String DEFAULT_ELSER_2_INFERENCE_ID = ".elser-2-elasticsearch";
    private final IndexSettings indexSettings;
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated(), arg_0 -> ((MappingParserContext)c).bitSetProducer(arg_0), c.getIndexSettings()), List.of(SemanticTextFieldMapper.notInMultiFields((String)"semantic_text"), SemanticTextFieldMapper.notFromDynamicTemplates((String)"semantic_text")));

    private SemanticTextFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, IndexSettings indexSettings) {
        super(simpleName, mappedFieldType, builderParams);
        this.indexSettings = indexSettings;
    }

    public Iterator<Mapper> iterator() {
        ArrayList<ObjectMapper> subIterators = new ArrayList<ObjectMapper>();
        subIterators.add(this.fieldType().getInferenceField());
        return subIterators.iterator();
    }

    public FieldMapper.Builder getMergeBuilder() {
        return Builder.from(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        SemanticTextFieldMapper mapper;
        SemanticTextField field;
        XContentParser parser = context.parser();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        XContentLocation xContentLocation = parser.getTokenLocation();
        boolean isWithinLeaf = context.path().isWithinLeafObject();
        try {
            context.path().setWithinLeafObject(true);
            field = SemanticTextField.parse(parser, (Tuple<String, XContentType>)new Tuple((Object)this.fullPath(), (Object)context.parser().contentType()));
        }
        finally {
            context.path().setWithinLeafObject(isWithinLeaf);
        }
        String fullFieldName = this.fieldType().name();
        if (!field.inference().inferenceId().equals(this.fieldType().getInferenceId())) {
            throw new DocumentParsingException(xContentLocation, Strings.format((String)"The configured %s [%s] for field [%s] doesn't match the %s [%s] reported in the document.", (Object[])new Object[]{"inference_id", field.inference().inferenceId(), fullFieldName, "inference_id", this.fieldType().getInferenceId()}));
        }
        if (this.fieldType().getModelSettings() == null) {
            context.path().remove();
            Builder builder = (Builder)new Builder(this.leafName(), this.fieldType().indexVersionCreated, this.fieldType().getChunksField().bitsetProducer(), this.indexSettings).init(this);
            try {
                mapper = builder.setModelSettings(field.inference().modelSettings()).setInferenceId(field.inference().inferenceId()).build(context.createDynamicMapperBuilderContext());
                context.addDynamicMapper((Mapper)mapper);
            }
            finally {
                context.path().add(this.leafName());
            }
        }
        FieldMapper.Conflicts conflicts = new FieldMapper.Conflicts(fullFieldName);
        SemanticTextFieldMapper.canMergeModelSettings(this.fieldType().getModelSettings(), field.inference().modelSettings(), conflicts);
        try {
            conflicts.check();
        }
        catch (Exception exc) {
            throw new DocumentParsingException(xContentLocation, "Incompatible model settings for field [" + this.fullPath() + "]. Check that the inference_id is not using different model settings", exc);
        }
        mapper = this;
        NestedObjectMapper chunksField = mapper.fieldType().getChunksField();
        FieldMapper embeddingsField = mapper.fieldType().getEmbeddingsField();
        for (SemanticTextField.Chunk chunk : field.inference().chunks()) {
            XContentParser subParser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)chunk.rawEmbeddings(), (XContentType)context.parser().contentType());
            try {
                DocumentParserContext subContext = context.createNestedContext(chunksField).switchParser(subParser);
                subParser.nextToken();
                embeddingsField.parse(subContext);
            }
            finally {
                if (subParser == null) continue;
                subParser.close();
            }
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public SemanticTextFieldType fieldType() {
        return (SemanticTextFieldType)super.fieldType();
    }

    public InferenceFieldMetadata getMetadata(Set<String> sourcePaths) {
        Object[] copyFields = (String[])sourcePaths.toArray(String[]::new);
        Arrays.sort(copyFields);
        return new InferenceFieldMetadata(this.fullPath(), this.fieldType().getInferenceId(), this.fieldType().getSearchInferenceId(), (String[])copyFields);
    }

    public Object getOriginalValue(Map<String, Object> sourceAsMap) {
        Object fieldValue = sourceAsMap.get(this.fullPath());
        if (fieldValue == null) {
            return null;
        }
        if (!(fieldValue instanceof Map)) {
            return fieldValue;
        }
        Map fieldValueMap = XContentMapValues.nodeMapValue((Object)fieldValue, (String)("Field [" + this.fullPath() + "]"));
        return XContentMapValues.extractValue((String)"text", (Map)fieldValueMap);
    }

    protected void doValidate(MappingLookup mappers) {
        int parentPathIndex = this.fullPath().lastIndexOf(this.leafName());
        if (parentPathIndex > 0) {
            ObjectMapper parentMapper = (ObjectMapper)mappers.objectMappers().get(this.fullPath().substring(0, parentPathIndex - 1));
            if (parentMapper == null) {
                throw new IllegalStateException("semantic_text field [" + this.fullPath() + "] does not have a parent object mapper");
            }
            if (parentMapper.subobjects() == ObjectMapper.Subobjects.DISABLED) {
                throw new IllegalArgumentException("semantic_text field [" + this.fullPath() + "] cannot be in an object field with subobjects disabled");
            }
        }
    }

    public static void insertValue(String path, Map<?, ?> map, Object newValue) {
        String[] pathElements = path.split("\\.");
        if (pathElements.length == 0) {
            return;
        }
        List<SuffixMap> suffixMaps = SemanticTextFieldMapper.extractSuffixMaps(pathElements, 0, map);
        if (suffixMaps.isEmpty()) {
            throw new IllegalStateException("extractSuffixMaps returned an empty suffix map list");
        }
        if (suffixMaps.size() != 1) {
            throw new IllegalArgumentException("Path [" + path + "] could be inserted in " + suffixMaps.size() + " distinct ways, it is ambiguous which one to use");
        }
        SuffixMap suffixMap = suffixMaps.get(0);
        suffixMap.map().put(suffixMap.suffix(), newValue);
    }

    private static List<SuffixMap> extractSuffixMaps(String[] pathElements, int index, Object currentValue) {
        if (currentValue instanceof List) {
            List valueList = (List)currentValue;
            ArrayList<SuffixMap> suffixMaps = new ArrayList<SuffixMap>(valueList.size());
            for (Object o : valueList) {
                suffixMaps.addAll(SemanticTextFieldMapper.extractSuffixMaps(pathElements, index, o));
            }
            return suffixMaps;
        }
        if (currentValue instanceof Map) {
            Map map = (Map)currentValue;
            ArrayList<SuffixMap> suffixMaps = new ArrayList<SuffixMap>(map.size());
            Object key = pathElements[index];
            while (index < pathElements.length) {
                if (map.containsKey(key)) {
                    if (index + 1 == pathElements.length) {
                        suffixMaps.add(new SuffixMap((String)key, map));
                    } else {
                        suffixMaps.addAll(SemanticTextFieldMapper.extractSuffixMaps(pathElements, index + 1, map.get(key)));
                    }
                }
                if (++index >= pathElements.length) continue;
                key = (String)key + "." + pathElements[index];
            }
            if (suffixMaps.isEmpty()) {
                suffixMaps.add(new SuffixMap((String)key, map));
            }
            return suffixMaps;
        }
        throw new IllegalArgumentException("Path [" + String.join((CharSequence)".", Arrays.copyOfRange(pathElements, 0, index)) + "] has value [" + String.valueOf(currentValue) + "] of type [" + currentValue.getClass().getSimpleName() + "], which cannot be traversed into further");
    }

    private static ObjectMapper createInferenceField(MapperBuilderContext context, IndexVersion indexVersionCreated, @Nullable SemanticTextField.ModelSettings modelSettings, Function<Query, BitSetProducer> bitSetProducer, IndexSettings indexSettings) {
        return new ObjectMapper.Builder("inference", Optional.of(ObjectMapper.Subobjects.ENABLED)).dynamic(ObjectMapper.Dynamic.FALSE).add((Mapper.Builder)SemanticTextFieldMapper.createChunksField(indexVersionCreated, modelSettings, bitSetProducer, indexSettings)).build(context);
    }

    private static NestedObjectMapper.Builder createChunksField(IndexVersion indexVersionCreated, @Nullable SemanticTextField.ModelSettings modelSettings, Function<Query, BitSetProducer> bitSetProducer, IndexSettings indexSettings) {
        NestedObjectMapper.Builder chunksField = new NestedObjectMapper.Builder("chunks", indexVersionCreated, bitSetProducer, indexSettings);
        chunksField.dynamic(ObjectMapper.Dynamic.FALSE);
        KeywordFieldMapper.Builder chunkTextField = new KeywordFieldMapper.Builder("text", indexVersionCreated).indexed(false).docValues(false);
        if (modelSettings != null) {
            chunksField.add(SemanticTextFieldMapper.createEmbeddingsField(indexVersionCreated, modelSettings));
        }
        chunksField.add((Mapper.Builder)chunkTextField);
        return chunksField;
    }

    private static Mapper.Builder createEmbeddingsField(IndexVersion indexVersionCreated, SemanticTextField.ModelSettings modelSettings) {
        return switch (modelSettings.taskType()) {
            case TaskType.SPARSE_EMBEDDING -> new SparseVectorFieldMapper.Builder("embeddings");
            case TaskType.TEXT_EMBEDDING -> {
                DenseVectorFieldMapper.Builder denseVectorMapperBuilder = new DenseVectorFieldMapper.Builder("embeddings", indexVersionCreated);
                SimilarityMeasure similarity = modelSettings.similarity();
                if (similarity != null) {
                    switch (similarity) {
                        case COSINE: {
                            denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.COSINE);
                            break;
                        }
                        case DOT_PRODUCT: {
                            denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.DOT_PRODUCT);
                            break;
                        }
                        case L2_NORM: {
                            denseVectorMapperBuilder.similarity(DenseVectorFieldMapper.VectorSimilarity.L2_NORM);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown similarity measure in model_settings [" + similarity.name() + "]");
                        }
                    }
                }
                denseVectorMapperBuilder.dimensions(modelSettings.dimensions().intValue());
                denseVectorMapperBuilder.elementType(modelSettings.elementType());
                yield denseVectorMapperBuilder;
            }
            default -> throw new IllegalArgumentException("Invalid task_type in model_settings [" + modelSettings.taskType().name() + "]");
        };
    }

    private static boolean canMergeModelSettings(SemanticTextField.ModelSettings previous, SemanticTextField.ModelSettings current, FieldMapper.Conflicts conflicts) {
        if (Objects.equals(previous, current)) {
            return true;
        }
        if (previous == null) {
            return true;
        }
        conflicts.addConflict("model_settings", "");
        return false;
    }

    public static class SemanticTextFieldType
    extends SimpleMappedFieldType {
        private final String inferenceId;
        private final String searchInferenceId;
        private final SemanticTextField.ModelSettings modelSettings;
        private final ObjectMapper inferenceField;
        private final IndexVersion indexVersionCreated;

        public SemanticTextFieldType(String name, String inferenceId, String searchInferenceId, SemanticTextField.ModelSettings modelSettings, ObjectMapper inferenceField, IndexVersion indexVersionCreated, Map<String, String> meta) {
            super(name, true, false, false, TextSearchInfo.NONE, meta);
            this.inferenceId = inferenceId;
            this.searchInferenceId = searchInferenceId;
            this.modelSettings = modelSettings;
            this.inferenceField = inferenceField;
            this.indexVersionCreated = indexVersionCreated;
        }

        public String typeName() {
            return SemanticTextFieldMapper.CONTENT_TYPE;
        }

        public String getInferenceId() {
            return this.inferenceId;
        }

        public String getSearchInferenceId() {
            return this.searchInferenceId == null ? this.inferenceId : this.searchInferenceId;
        }

        public SemanticTextField.ModelSettings getModelSettings() {
            return this.modelSettings;
        }

        public ObjectMapper getInferenceField() {
            return this.inferenceField;
        }

        public NestedObjectMapper getChunksField() {
            return (NestedObjectMapper)this.inferenceField.getMapper("chunks");
        }

        public FieldMapper getEmbeddingsField() {
            return (FieldMapper)this.getChunksField().getMapper("embeddings");
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("semantic_text fields do not support term query");
        }

        public Query existsQuery(SearchExecutionContext context) {
            if (this.getEmbeddingsField() == null) {
                return new MatchNoDocsQuery();
            }
            return NestedQueryBuilder.toQuery(c -> this.getEmbeddingsField().fieldType().existsQuery(c), (String)SemanticTextField.getChunksFieldName(this.name()), (ScoreMode)ScoreMode.None, (boolean)false, (SearchExecutionContext)context);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString((String)SemanticTextField.getOriginalTextFieldName(this.name()), (SearchExecutionContext)context, (String)format);
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            throw new IllegalArgumentException("[semantic_text] fields do not support sorting, scripting or aggregating");
        }

        public boolean fieldHasValue(FieldInfos fieldInfos) {
            return fieldInfos.fieldInfo(SemanticTextField.getEmbeddingsFieldName(this.name())) != null;
        }

        public QueryBuilder semanticQuery(InferenceResults inferenceResults, Integer requestSize, float boost, String queryName) {
            MatchNoneQueryBuilder childQueryBuilder;
            String nestedFieldPath = SemanticTextField.getChunksFieldName(this.name());
            String inferenceResultsFieldName = SemanticTextField.getEmbeddingsFieldName(this.name());
            if (this.modelSettings == null) {
                childQueryBuilder = new MatchNoneQueryBuilder();
            } else {
                childQueryBuilder = switch (this.modelSettings.taskType()) {
                    case TaskType.SPARSE_EMBEDDING -> {
                        if (!(inferenceResults instanceof TextExpansionResults)) {
                            throw new IllegalArgumentException(this.generateQueryInferenceResultsTypeMismatchMessage(inferenceResults, "text_expansion_result"));
                        }
                        TextExpansionResults textExpansionResults = (TextExpansionResults)inferenceResults;
                        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                        for (WeightedToken weightedToken : textExpansionResults.getWeightedTokens()) {
                            boolQuery.should((QueryBuilder)QueryBuilders.termQuery((String)inferenceResultsFieldName, (String)weightedToken.token()).boost(weightedToken.weight()));
                        }
                        boolQuery.minimumShouldMatch(1);
                        yield boolQuery;
                    }
                    case TaskType.TEXT_EMBEDDING -> {
                        if (!(inferenceResults instanceof MlTextEmbeddingResults)) {
                            throw new IllegalArgumentException(this.generateQueryInferenceResultsTypeMismatchMessage(inferenceResults, "text_embedding_result"));
                        }
                        MlTextEmbeddingResults textEmbeddingResults = (MlTextEmbeddingResults)inferenceResults;
                        float[] inference = textEmbeddingResults.getInferenceAsFloat();
                        if (inference.length != this.modelSettings.dimensions()) {
                            throw new IllegalArgumentException(this.generateDimensionCountMismatchMessage(inference.length, this.modelSettings.dimensions()));
                        }
                        Integer k = requestSize;
                        if (k != null) {
                            k = Math.max(k, 10);
                        }
                        yield new KnnVectorQueryBuilder(inferenceResultsFieldName, inference, k, null, null);
                    }
                    default -> throw new IllegalStateException("Field [" + this.name() + "] is configured to use an inference endpoint with an unsupported task type [" + String.valueOf(this.modelSettings.taskType()) + "]");
                };
            }
            return ((NestedQueryBuilder)new NestedQueryBuilder(nestedFieldPath, (QueryBuilder)childQueryBuilder, ScoreMode.Max).boost(boost)).queryName(queryName);
        }

        private String generateQueryInferenceResultsTypeMismatchMessage(InferenceResults inferenceResults, String expectedResultsType) {
            StringBuilder sb = new StringBuilder("Field [" + this.name() + "] expected query inference results to be of type [" + expectedResultsType + "], got [" + inferenceResults.getWriteableName() + "].");
            return this.generateInvalidQueryInferenceResultsMessage(sb);
        }

        private String generateDimensionCountMismatchMessage(int inferenceDimCount, int expectedDimCount) {
            StringBuilder sb = new StringBuilder("Field [" + this.name() + "] expected query inference results with " + expectedDimCount + " dimensions, got " + inferenceDimCount + " dimensions.");
            return this.generateInvalidQueryInferenceResultsMessage(sb);
        }

        private String generateInvalidQueryInferenceResultsMessage(StringBuilder baseMessageBuilder) {
            if (this.searchInferenceId != null && !this.searchInferenceId.equals(this.inferenceId)) {
                baseMessageBuilder.append(" Is the search inference endpoint [" + this.searchInferenceId + "] compatible with the inference endpoint [" + this.inferenceId + "]?");
            } else {
                baseMessageBuilder.append(" Has the configuration for inference endpoint [" + this.inferenceId + "] changed?");
            }
            return baseMessageBuilder.toString();
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            SourceValueFetcher fetcher = SourceValueFetcher.toString((Set)blContext.sourcePaths(this.name().concat(".text")));
            return new BlockSourceReader.BytesRefsBlockLoader((ValueFetcher)fetcher, BlockSourceReader.lookupMatchingAll());
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final IndexVersion indexVersionCreated;
        private final IndexSettings indexSettings;
        private final FieldMapper.Parameter<String> inferenceId = FieldMapper.Parameter.stringParam((String)"inference_id", (boolean)false, mapper -> ((SemanticTextFieldType)mapper.fieldType()).inferenceId, (String)".elser-2-elasticsearch").addValidator(v -> {
            if (Strings.isEmpty((CharSequence)v)) {
                throw new IllegalArgumentException("[inference_id] on mapper [" + this.leafName() + "] of type [semantic_text] must not be empty");
            }
        }).alwaysSerialize();
        private final FieldMapper.Parameter<String> searchInferenceId = FieldMapper.Parameter.stringParam((String)"search_inference_id", (boolean)true, mapper -> ((SemanticTextFieldType)mapper.fieldType()).searchInferenceId, null).acceptsNull().addValidator(v -> {
            if (v != null && Strings.isEmpty((CharSequence)v)) {
                throw new IllegalArgumentException("[search_inference_id] on mapper [" + this.leafName() + "] of type [semantic_text] must not be empty");
            }
        });
        private final FieldMapper.Parameter<SemanticTextField.ModelSettings> modelSettings = new FieldMapper.Parameter("model_settings", true, () -> null, (n, c, o) -> SemanticTextField.parseModelSettingsFromMap(o), mapper -> ((SemanticTextFieldType)mapper.fieldType()).modelSettings, XContentBuilder::field, Objects::toString).acceptsNull().setMergeValidator(SemanticTextFieldMapper::canMergeModelSettings);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private Function<MapperBuilderContext, ObjectMapper> inferenceFieldBuilder;

        public static Builder from(SemanticTextFieldMapper mapper) {
            Builder builder = new Builder(mapper.leafName(), mapper.fieldType().indexVersionCreated, mapper.fieldType().getChunksField().bitsetProducer(), mapper.indexSettings);
            builder.init(mapper);
            return builder;
        }

        public Builder(String name, IndexVersion indexVersionCreated, Function<Query, BitSetProducer> bitSetProducer, IndexSettings indexSettings) {
            super(name);
            this.indexVersionCreated = indexVersionCreated;
            this.indexSettings = indexSettings;
            this.inferenceFieldBuilder = c -> SemanticTextFieldMapper.createInferenceField(c, indexVersionCreated, (SemanticTextField.ModelSettings)this.modelSettings.get(), bitSetProducer, indexSettings);
        }

        public Builder setInferenceId(String id) {
            this.inferenceId.setValue((Object)id);
            return this;
        }

        public Builder setSearchInferenceId(String id) {
            this.searchInferenceId.setValue((Object)id);
            return this;
        }

        public Builder setModelSettings(SemanticTextField.ModelSettings value) {
            this.modelSettings.setValue((Object)value);
            return this;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.inferenceId, this.searchInferenceId, this.modelSettings, this.meta};
        }

        protected void merge(FieldMapper mergeWith, FieldMapper.Conflicts conflicts, MapperMergeContext mapperMergeContext) {
            SemanticTextFieldMapper semanticMergeWith = (SemanticTextFieldMapper)mergeWith;
            semanticMergeWith = this.copySettings(semanticMergeWith, mapperMergeContext);
            super.merge((FieldMapper)semanticMergeWith, conflicts, mapperMergeContext);
            conflicts.check();
            MapperMergeContext context = mapperMergeContext.createChildContext(semanticMergeWith.leafName(), ObjectMapper.Dynamic.FALSE);
            ObjectMapper inferenceField = this.inferenceFieldBuilder.apply(context.getMapperBuilderContext());
            ObjectMapper mergedInferenceField = inferenceField.merge((Mapper)semanticMergeWith.fieldType().getInferenceField(), context);
            this.inferenceFieldBuilder = c -> mergedInferenceField;
        }

        public SemanticTextFieldMapper build(MapperBuilderContext context) {
            if (!this.copyTo.copyToFields().isEmpty()) {
                throw new IllegalArgumentException("semantic_text field [" + this.leafName() + "] does not support [copy_to]");
            }
            if (this.multiFieldsBuilder.hasMultiFields()) {
                throw new IllegalArgumentException("semantic_text field [" + this.leafName() + "] does not support multi-fields");
            }
            String fullName = context.buildFullName(this.leafName());
            if (context.isInNestedContext()) {
                throw new IllegalArgumentException("semantic_text field [" + fullName + "] cannot be nested");
            }
            MapperBuilderContext childContext = context.createChildContext(this.leafName(), ObjectMapper.Dynamic.FALSE);
            ObjectMapper inferenceField = this.inferenceFieldBuilder.apply(childContext);
            return new SemanticTextFieldMapper(this.leafName(), (MappedFieldType)new SemanticTextFieldType(fullName, (String)this.inferenceId.getValue(), (String)this.searchInferenceId.getValue(), (SemanticTextField.ModelSettings)this.modelSettings.getValue(), inferenceField, this.indexVersionCreated, (Map)this.meta.getValue()), this.builderParams((Mapper.Builder)this, context), this.indexSettings);
        }

        private SemanticTextFieldMapper copySettings(SemanticTextFieldMapper mapper, MapperMergeContext mapperMergeContext) {
            SemanticTextFieldMapper returnedMapper = mapper;
            if (mapper.fieldType().getModelSettings() == null) {
                Builder builder = Builder.from(mapper);
                builder.setModelSettings((SemanticTextField.ModelSettings)this.modelSettings.getValue());
                returnedMapper = builder.build(mapperMergeContext.getMapperBuilderContext());
            }
            return returnedMapper;
        }
    }

    private record SuffixMap(String suffix, Map<String, Object> map) {
    }
}

