/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ListenerTimeouts;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.RejectableTask;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;

class RequestTask
implements RejectableTask {
    private final AtomicBoolean finished = new AtomicBoolean();
    private final RequestManager requestCreator;
    private final InferenceInputs inferenceInputs;
    private final ActionListener<InferenceServiceResults> listener;

    RequestTask(RequestManager requestCreator, InferenceInputs inferenceInputs, @Nullable TimeValue timeout, ThreadPool threadPool, ActionListener<InferenceServiceResults> listener) {
        this.requestCreator = Objects.requireNonNull(requestCreator);
        this.listener = this.getListener(Objects.requireNonNull(listener), timeout, Objects.requireNonNull(threadPool));
        this.inferenceInputs = Objects.requireNonNull(inferenceInputs);
    }

    private ActionListener<InferenceServiceResults> getListener(ActionListener<InferenceServiceResults> origListener, @Nullable TimeValue timeout, ThreadPool threadPool) {
        ActionListener notificationListener = ActionListener.wrap(result -> {
            this.finished.set(true);
            origListener.onResponse(result);
        }, e -> {
            this.finished.set(true);
            origListener.onFailure(e);
        });
        if (timeout == null) {
            return notificationListener;
        }
        return ListenerTimeouts.wrapWithTimeout((ThreadPool)threadPool, (TimeValue)timeout, (Executor)threadPool.executor("inference_utility"), (ActionListener)notificationListener, ignored -> notificationListener.onFailure((Exception)new ElasticsearchTimeoutException(Strings.format((String)"Request timed out waiting to be sent after [%s]", (Object[])new Object[]{timeout}), new Object[0])));
    }

    @Override
    public boolean hasCompleted() {
        return this.finished.get();
    }

    @Override
    public Supplier<Boolean> getRequestCompletedFunction() {
        return this::hasCompleted;
    }

    @Override
    public InferenceInputs getInferenceInputs() {
        return this.inferenceInputs;
    }

    @Override
    public ActionListener<InferenceServiceResults> getListener() {
        return this.listener;
    }

    @Override
    public void onRejection(Exception e) {
        this.listener.onFailure(e);
    }

    @Override
    public RequestManager getRequestManager() {
        return this.requestCreator;
    }
}

