/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.arrow;

import java.lang.reflect.Field;
import java.security.AccessController;
import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.DefaultAllocationManagerOption;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class AllocationManagerShim
implements AllocationManager.Factory {
    private static final Logger logger = LogManager.getLogger(AllocationManagerShim.class);

    @SuppressForbidden(reason="Inject the default Arrow memory allocation manager")
    public static void init() {
        try {
            Class.forName("org.elasticsearch.test.ESTestCase");
            logger.info("We're in tests, not disabling Arrow memory manager so we can use a real runtime for testing");
        }
        catch (ClassNotFoundException notfound) {
            logger.debug("Disabling Arrow's allocation manager");
            AccessController.doPrivileged(() -> {
                try {
                    Field field = DefaultAllocationManagerOption.class.getDeclaredField("DEFAULT_ALLOCATION_MANAGER_FACTORY");
                    field.setAccessible(true);
                    field.set(null, new AllocationManagerShim());
                }
                catch (Exception e) {
                    throw new AssertionError("Can't init Arrow", e);
                }
                return null;
            });
        }
    }

    public AllocationManager create(BufferAllocator accountingAllocator, long size) {
        throw new UnsupportedOperationException("Arrow memory manager is disabled");
    }

    public ArrowBuf empty() {
        throw new UnsupportedOperationException("Arrow memory manager is disabled");
    }
}

