/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ResultDeduplicator;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThrottledTaskRunner;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotIndexCommit;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.snapshots.AbortedSnapshotException;
import org.elasticsearch.snapshots.PausedSnapshotException;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.snapshots.UpdateIndexShardSnapshotStatusRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public final class SnapshotShardsService
extends AbstractLifecycleComponent
implements ClusterStateListener,
IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SnapshotShardsService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final RepositoriesService repositoriesService;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> shardSnapshots = new HashMap<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>();
    private final ResultDeduplicator<UpdateIndexShardSnapshotStatusRequest, Void> remoteFailedRequestDeduplicator;
    private final ThrottledTaskRunner notifyOnAbortTaskRunner;

    public SnapshotShardsService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, TransportService transportService, IndicesService indicesService) {
        this.indicesService = indicesService;
        this.repositoriesService = repositoriesService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = transportService.getThreadPool();
        this.remoteFailedRequestDeduplicator = new ResultDeduplicator(this.threadPool.getThreadContext());
        if (DiscoveryNode.canContainData(settings)) {
            clusterService.addListener(this);
        }
        this.notifyOnAbortTaskRunner = new ThrottledTaskRunner("notify-on-abort", this.threadPool.info("snapshot").getMax(), this.threadPool.generic());
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.clusterService.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            SnapshotsInProgress currentSnapshots = SnapshotsInProgress.get(event.state());
            if (!SnapshotsInProgress.get(event.previousState()).equals(currentSnapshots)) {
                String localNodeId = this.clusterService.localNode().getId();
                Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
                synchronized (map) {
                    this.cancelRemoved(currentSnapshots);
                    for (List<SnapshotsInProgress.Entry> oneRepoSnapshotsInProgress : currentSnapshots.entriesByRepo()) {
                        for (SnapshotsInProgress.Entry snapshotsInProgressEntry : oneRepoSnapshotsInProgress) {
                            this.handleUpdatedSnapshotsInProgressEntry(localNodeId, currentSnapshots.isNodeIdForRemoval(localNodeId), snapshotsInProgressEntry);
                        }
                    }
                }
            }
            String previousMasterNodeId = event.previousState().nodes().getMasterNodeId();
            String currentMasterNodeId = event.state().nodes().getMasterNodeId();
            if (currentMasterNodeId != null && !currentMasterNodeId.equals(previousMasterNodeId)) {
                this.remoteFailedRequestDeduplicator.clear();
                for (List<SnapshotsInProgress.Entry> snapshots : currentSnapshots.entriesByRepo()) {
                    this.syncShardStatsOnNewMaster(snapshots);
                }
            }
        }
        catch (Exception e) {
            assert (false) : new AssertionError((Object)e);
            logger.warn("failed to update snapshot state", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            for (Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> snapshotShards : this.shardSnapshots.entrySet()) {
                IndexShardSnapshotStatus indexShardSnapshotStatus = snapshotShards.getValue().get(shardId);
                if (indexShardSnapshotStatus == null) continue;
                logger.debug("[{}] shard closing, abort snapshotting for snapshot [{}]", (Object)shardId, (Object)snapshotShards.getKey().getSnapshotId());
                indexShardSnapshotStatus.abortIfNotCompleted("shard is closing, aborting", this.notifyOnAbortTaskRunner::enqueueTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ShardId, IndexShardSnapshotStatus.Copy> currentSnapshotShards(Snapshot snapshot) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            Map<ShardId, IndexShardSnapshotStatus> current = this.shardSnapshots.get(snapshot);
            if (current == null) {
                return null;
            }
            Map<ShardId, IndexShardSnapshotStatus.Copy> result = Maps.newMapWithExpectedSize(current.size());
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> entry : current.entrySet()) {
                result.put(entry.getKey(), entry.getValue().asCopy());
            }
            return result;
        }
    }

    private void cancelRemoved(SnapshotsInProgress snapshotsInProgress) {
        Iterator<Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>> it = this.shardSnapshots.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> entry = it.next();
            Snapshot snapshot = entry.getKey();
            if (snapshotsInProgress.snapshot(snapshot) != null) continue;
            it.remove();
            for (IndexShardSnapshotStatus snapshotStatus : entry.getValue().values()) {
                snapshotStatus.abortIfNotCompleted("snapshot has been removed in cluster state, aborting", this.notifyOnAbortTaskRunner::enqueueTask);
            }
        }
    }

    private void handleUpdatedSnapshotsInProgressEntry(String localNodeId, boolean removingLocalNode, SnapshotsInProgress.Entry entry) {
        if (entry.isClone()) {
            return;
        }
        switch (entry.state()) {
            case STARTED: {
                if (!entry.hasShardsInInitState()) {
                    return;
                }
                if (removingLocalNode) {
                    this.pauseShardSnapshotsForNodeRemoval(localNodeId, entry);
                    break;
                }
                this.startNewShardSnapshots(localNodeId, entry);
                break;
            }
            case ABORTED: {
                Snapshot snapshot = entry.snapshot();
                Map snapshotShards = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
                for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shard : entry.shardSnapshotStatusByRepoShardId().entrySet()) {
                    ShardId sid = entry.shardId(shard.getKey());
                    IndexShardSnapshotStatus snapshotStatus = (IndexShardSnapshotStatus)snapshotShards.get(sid);
                    if (snapshotStatus == null) {
                        if (shard.getValue().state() != SnapshotsInProgress.ShardState.ABORTED || !localNodeId.equals(shard.getValue().nodeId())) continue;
                        this.notifyUnsuccessfulSnapshotShard(snapshot, sid, SnapshotsInProgress.ShardState.FAILED, shard.getValue().reason(), shard.getValue().generation());
                        continue;
                    }
                    snapshotStatus.abortIfNotCompleted("snapshot has been aborted", this.notifyOnAbortTaskRunner::enqueueTask);
                }
                break;
            }
        }
    }

    private void startNewShardSnapshots(String localNodeId, SnapshotsInProgress.Entry entry) {
        HashMap<ShardId, ShardGeneration> shardsToStart = null;
        Snapshot snapshot = entry.snapshot();
        Map runningShardsForSnapshot = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
        for (Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> scheduledShard : entry.shards().entrySet()) {
            IndexShardSnapshotStatus runningShard;
            ShardId shardId = scheduledShard.getKey();
            SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = scheduledShard.getValue();
            if (shardSnapshotStatus.state() != SnapshotsInProgress.ShardState.INIT || !localNodeId.equals(shardSnapshotStatus.nodeId()) || (runningShard = (IndexShardSnapshotStatus)runningShardsForSnapshot.get(shardId)) != null && !runningShard.isPaused()) continue;
            logger.trace("[{}] adding [{}] shard to the queue", (Object)shardId, (Object)(runningShard == null ? "new" : "paused"));
            if (shardsToStart == null) {
                shardsToStart = new HashMap<ShardId, ShardGeneration>();
            }
            shardsToStart.put(shardId, shardSnapshotStatus.generation());
        }
        if (shardsToStart == null) {
            return;
        }
        assert (!shardsToStart.isEmpty());
        Map newSnapshotShards = this.shardSnapshots.computeIfAbsent(snapshot, s -> new HashMap());
        ArrayList<Runnable> shardSnapshotTasks = new ArrayList<Runnable>(shardsToStart.size());
        for (Map.Entry shardEntry : shardsToStart.entrySet()) {
            ShardId shardId = (ShardId)shardEntry.getKey();
            IndexShardSnapshotStatus snapshotStatus = IndexShardSnapshotStatus.newInitializing((ShardGeneration)shardEntry.getValue());
            newSnapshotShards.put(shardId, snapshotStatus);
            IndexId indexId = entry.indices().get(shardId.getIndexName());
            assert (indexId != null);
            assert (SnapshotsService.useShardGenerations(entry.version()) || ShardGenerations.fixShardGeneration(snapshotStatus.generation()) == null) : "Found non-null, non-numeric shard generation [" + String.valueOf(snapshotStatus.generation()) + "] for snapshot with old-format compatibility";
            shardSnapshotTasks.add(this.newShardSnapshotTask(shardId, snapshot, indexId, snapshotStatus, entry.version(), entry.startTime()));
        }
        this.threadPool.executor("snapshot").execute(() -> shardSnapshotTasks.forEach(Runnable::run));
    }

    private void pauseShardSnapshotsForNodeRemoval(String localNodeId, SnapshotsInProgress.Entry entry) {
        Map localShardSnapshots = this.shardSnapshots.getOrDefault(entry.snapshot(), Map.of());
        for (Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardEntry : entry.shards().entrySet()) {
            ShardId shardId = shardEntry.getKey();
            SnapshotsInProgress.ShardSnapshotStatus masterShardSnapshotStatus = shardEntry.getValue();
            if (masterShardSnapshotStatus.state() != SnapshotsInProgress.ShardState.INIT || !localNodeId.equals(masterShardSnapshotStatus.nodeId())) continue;
            IndexShardSnapshotStatus localShardSnapshotStatus = (IndexShardSnapshotStatus)localShardSnapshots.get(shardId);
            if (localShardSnapshotStatus == null) {
                this.notifyUnsuccessfulSnapshotShard(entry.snapshot(), shardId, SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL, "paused", masterShardSnapshotStatus.generation());
                continue;
            }
            localShardSnapshotStatus.pauseIfNotCompleted(this.notifyOnAbortTaskRunner::enqueueTask);
        }
    }

    private Runnable newShardSnapshotTask(final ShardId shardId, final Snapshot snapshot, IndexId indexId, final IndexShardSnapshotStatus snapshotStatus, IndexVersion entryVersion, long entryStartTime) {
        return () -> this.snapshot(shardId, snapshot, indexId, snapshotStatus, entryVersion, entryStartTime, new ActionListener<ShardSnapshotResult>(){

            @Override
            public void onResponse(ShardSnapshotResult shardSnapshotResult) {
                ShardGeneration newGeneration = shardSnapshotResult.getGeneration();
                assert (newGeneration != null);
                assert (newGeneration.equals(snapshotStatus.generation()));
                if (logger.isDebugEnabled()) {
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.asCopy();
                    logger.debug("[{}][{}] completed snapshot to [{}] with status [{}] at generation [{}]", (Object)shardId, (Object)snapshot, (Object)snapshot.getRepository(), (Object)lastSnapshotStatus, (Object)snapshotStatus.generation());
                }
                SnapshotShardsService.this.notifySuccessfulSnapshotShard(snapshot, shardId, shardSnapshotResult);
            }

            @Override
            public void onFailure(Exception e) {
                String failure;
                IndexShardSnapshotStatus.Stage nextStage;
                if (e instanceof AbortedSnapshotException) {
                    nextStage = IndexShardSnapshotStatus.Stage.FAILURE;
                    failure = "aborted";
                    logger.debug(() -> Strings.format((String)"[%s][%s] aborted shard snapshot", (Object[])new Object[]{shardId, snapshot}), (Throwable)e);
                } else if (e instanceof PausedSnapshotException) {
                    nextStage = IndexShardSnapshotStatus.Stage.PAUSED;
                    failure = "paused for removal of node holding primary";
                    logger.debug(() -> Strings.format((String)"[%s][%s] pausing shard snapshot", (Object[])new Object[]{shardId, snapshot}), (Throwable)e);
                } else {
                    nextStage = IndexShardSnapshotStatus.Stage.FAILURE;
                    failure = SnapshotShardsService.summarizeFailure(e);
                    logger.warn(() -> Strings.format((String)"[%s][%s] failed to snapshot shard", (Object[])new Object[]{shardId, snapshot}), (Throwable)e);
                }
                SnapshotsInProgress.ShardState shardState = snapshotStatus.moveToUnsuccessful(nextStage, failure, SnapshotShardsService.this.threadPool.absoluteTimeInMillis());
                SnapshotShardsService.this.notifyUnsuccessfulSnapshotShard(snapshot, shardId, shardState, failure, snapshotStatus.generation());
            }
        });
    }

    static String summarizeFailure(Throwable t) {
        if (t.getCause() == null) {
            return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
        }
        StringBuilder sb = new StringBuilder();
        while (t != null) {
            sb.append(t.getClass().getSimpleName());
            if (t.getMessage() != null) {
                sb.append("[");
                sb.append(t.getMessage());
                sb.append("]");
            }
            if ((t = t.getCause()) == null) continue;
            sb.append("; nested: ");
        }
        return sb.toString();
    }

    private void snapshot(ShardId shardId, Snapshot snapshot, IndexId indexId, IndexShardSnapshotStatus snapshotStatus, IndexVersion version, long entryStartTime, ActionListener<ShardSnapshotResult> resultListener) {
        ActionListener.run(resultListener, listener -> {
            snapshotStatus.ensureNotAborted();
            IndexShard indexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShard(shardId.id());
            if (!indexShard.routingEntry().primary()) {
                throw new IndexShardSnapshotFailedException(shardId, "snapshot should be performed only on primary");
            }
            if (indexShard.routingEntry().relocating()) {
                throw new IndexShardSnapshotFailedException(shardId, "cannot snapshot while relocating");
            }
            IndexShardState indexShardState = indexShard.state();
            if (indexShardState == IndexShardState.CREATED || indexShardState == IndexShardState.RECOVERING) {
                throw new IndexShardSnapshotFailedException(shardId, "shard didn't fully recover yet");
            }
            Repository repository = this.repositoriesService.repository(snapshot.getRepository());
            SnapshotIndexCommit snapshotIndexCommit = null;
            try {
                snapshotIndexCommit = new SnapshotIndexCommit(indexShard.acquireIndexCommitForSnapshot());
                String shardStateId = SnapshotShardsService.getShardStateId(indexShard, snapshotIndexCommit.indexCommit());
                snapshotStatus.addAbortListener(SnapshotShardsService.makeAbortListener(indexShard.shardId(), snapshot, snapshotIndexCommit));
                snapshotStatus.ensureNotAborted();
                repository.snapshotShard(new SnapshotShardContext(indexShard.store(), indexShard.mapperService(), snapshot.getSnapshotId(), indexId, snapshotIndexCommit, shardStateId, snapshotStatus, version, entryStartTime, (ActionListener<ShardSnapshotResult>)listener));
                snapshotIndexCommit = null;
                if (snapshotIndexCommit != null) {
                    snapshotIndexCommit.closingBefore(new ActionListener<Void>(){
                        final /* synthetic */ IndexShard val$indexShard;
                        final /* synthetic */ Snapshot val$snapshot;
                        {
                            this.val$indexShard = indexShard;
                            this.val$snapshot = snapshot;
                        }

                        @Override
                        public void onResponse(Void unused) {
                        }

                        @Override
                        public void onFailure(Exception e) {
                            logger.warn(org.elasticsearch.common.Strings.format("exception closing commit for [%s] in [%s]", this.val$indexShard.shardId(), this.val$snapshot), (Throwable)e);
                        }
                    }).onResponse(null);
                }
            }
            catch (Throwable throwable) {
                if (snapshotIndexCommit != null) {
                    snapshotIndexCommit.closingBefore(new /* invalid duplicate definition of identical inner class */).onResponse(null);
                }
                throw throwable;
            }
        });
    }

    private static ActionListener<IndexShardSnapshotStatus.AbortStatus> makeAbortListener(final ShardId shardId, final Snapshot snapshot, final SnapshotIndexCommit snapshotIndexCommit) {
        return new ActionListener<IndexShardSnapshotStatus.AbortStatus>(){

            @Override
            public void onResponse(IndexShardSnapshotStatus.AbortStatus abortStatus) {
                if (abortStatus == IndexShardSnapshotStatus.AbortStatus.ABORTED) {
                    assert (ThreadPool.assertCurrentThreadPool("generic", "snapshot"));
                    snapshotIndexCommit.onAbort();
                }
            }

            @Override
            public void onFailure(Exception e) {
                logger.error(() -> org.elasticsearch.common.Strings.format("unexpected failure in %s", this.description()), (Throwable)e);
                assert (false) : e;
            }

            public String toString() {
                return this.description();
            }

            private String description() {
                return org.elasticsearch.common.Strings.format("abort listener for [%s] in [%s]", shardId, snapshot);
            }
        };
    }

    @Nullable
    public static String getShardStateId(IndexShard indexShard, IndexCommit snapshotIndexCommit) throws IOException {
        Map userCommitData = snapshotIndexCommit.getUserData();
        SequenceNumbers.CommitInfo seqNumInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(userCommitData.entrySet());
        long maxSeqNo = seqNumInfo.maxSeqNo();
        if (maxSeqNo != seqNumInfo.localCheckpoint() || maxSeqNo != indexShard.getLastSyncedGlobalCheckpoint()) {
            return null;
        }
        return (String)userCommitData.get("history_uuid") + "-" + userCommitData.getOrDefault("force_merge_uuid", "na") + "-" + maxSeqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncShardStatsOnNewMaster(List<SnapshotsInProgress.Entry> entries) {
        for (SnapshotsInProgress.Entry snapshot : entries) {
            Map<ShardId, IndexShardSnapshotStatus> localShards;
            if (snapshot.state() != SnapshotsInProgress.State.STARTED && snapshot.state() != SnapshotsInProgress.State.ABORTED) continue;
            Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
            synchronized (map) {
                Map<ShardId, IndexShardSnapshotStatus> currentLocalShards = this.shardSnapshots.get(snapshot.snapshot());
                if (currentLocalShards == null) {
                    continue;
                }
                localShards = Map.copyOf(currentLocalShards);
            }
            Map<ShardId, SnapshotsInProgress.ShardSnapshotStatus> masterShards = snapshot.shards();
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> localShard : localShards.entrySet()) {
                ShardId shardId = localShard.getKey();
                SnapshotsInProgress.ShardSnapshotStatus masterShard = masterShards.get(shardId);
                if (masterShard == null || masterShard.state().completed()) continue;
                IndexShardSnapshotStatus.Copy indexShardSnapshotStatus = localShard.getValue().asCopy();
                IndexShardSnapshotStatus.Stage stage = indexShardSnapshotStatus.getStage();
                if (stage == IndexShardSnapshotStatus.Stage.DONE) {
                    logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard is done locally, updating status on the master", (Object)snapshot.snapshot(), (Object)shardId);
                    this.notifySuccessfulSnapshotShard(snapshot.snapshot(), shardId, localShard.getValue().getShardSnapshotResult());
                    continue;
                }
                if (stage == IndexShardSnapshotStatus.Stage.FAILURE) {
                    logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard failed locally, updating status on master", (Object)snapshot.snapshot(), (Object)shardId);
                    this.notifyUnsuccessfulSnapshotShard(snapshot.snapshot(), shardId, SnapshotsInProgress.ShardState.FAILED, indexShardSnapshotStatus.getFailure(), localShard.getValue().generation());
                    continue;
                }
                if (stage != IndexShardSnapshotStatus.Stage.PAUSED) continue;
                logger.debug("new master thinks that shard [{}] snapshot [{}], with shard generation [{}], is still running, but the shard snapshot is paused locally, updating status on master\n", (Object)shardId, (Object)snapshot.snapshot(), (Object)localShard.getValue().generation());
                this.notifyUnsuccessfulSnapshotShard(snapshot.snapshot(), shardId, SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL, indexShardSnapshotStatus.getFailure(), localShard.getValue().generation());
            }
        }
    }

    private void notifySuccessfulSnapshotShard(Snapshot snapshot, ShardId shardId, ShardSnapshotResult shardSnapshotResult) {
        assert (shardSnapshotResult != null);
        assert (shardSnapshotResult.getGeneration() != null);
        this.sendSnapshotShardUpdate(snapshot, shardId, SnapshotsInProgress.ShardSnapshotStatus.success(this.clusterService.localNode().getId(), shardSnapshotResult));
    }

    private void notifyUnsuccessfulSnapshotShard(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardState shardState, String failure, ShardGeneration generation) {
        assert (shardState == SnapshotsInProgress.ShardState.FAILED || shardState == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL) : shardState;
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(this.clusterService.localNode().getId(), shardState, generation, failure));
        if (shardState == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL) {
            logger.debug("Pausing shard [{}] snapshot [{}], with shard generation [{}], because this node is marked for removal", (Object)shardId, (Object)snapshot, (Object)generation);
        }
    }

    private void sendSnapshotShardUpdate(final Snapshot snapshot, final ShardId shardId, final SnapshotsInProgress.ShardSnapshotStatus status) {
        this.remoteFailedRequestDeduplicator.executeOnce(new UpdateIndexShardSnapshotStatusRequest(snapshot, shardId, status), new ActionListener<Void>(){

            @Override
            public void onResponse(Void aVoid) {
                logger.trace("[{}][{}] updated snapshot state to [{}]", (Object)shardId, (Object)snapshot, (Object)status);
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> Strings.format((String)"[%s][%s] failed to update snapshot state to [%s]", (Object[])new Object[]{shardId, snapshot, status}), (Throwable)e);
            }
        }, (req, reqListener) -> this.transportService.sendRequest(this.transportService.getLocalNode(), "internal:cluster/snapshot/update_snapshot_status", (TransportRequest)req, new ActionListenerResponseHandler<ActionResponse.Empty>(reqListener.map(res -> null), in -> ActionResponse.Empty.INSTANCE, TransportResponseHandler.TRANSPORT_WORKER)));
    }
}

