/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.retriever;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.RankDocsQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class RankDocsRetrieverBuilder
extends RetrieverBuilder {
    public static final String NAME = "rank_docs_retriever";
    final int rankWindowSize;
    final List<RetrieverBuilder> sources;
    final Supplier<RankDoc[]> rankDocs;

    public RankDocsRetrieverBuilder(int rankWindowSize, List<RetrieverBuilder> sources, Supplier<RankDoc[]> rankDocs) {
        this.rankWindowSize = rankWindowSize;
        this.rankDocs = rankDocs;
        if (sources == null || sources.isEmpty()) {
            throw new IllegalArgumentException("sources must not be null or empty");
        }
        this.sources = sources;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private boolean sourceHasMinScore() {
        return this.minScore != null || this.sources.stream().anyMatch(x -> x.minScore() != null);
    }

    private boolean sourceShouldRewrite(QueryRewriteContext ctx) throws IOException {
        for (RetrieverBuilder source : this.sources) {
            if (source.isCompound()) {
                return true;
            }
            RetrieverBuilder newSource = source.rewrite(ctx);
            if (newSource == source) continue;
            return true;
        }
        return false;
    }

    @Override
    public RetrieverBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        assert (!this.sourceShouldRewrite(ctx)) : "retriever sources should be rewritten first";
        return this;
    }

    @Override
    public QueryBuilder topDocsQuery() {
        BoolQueryBuilder boolQuery = new BoolQueryBuilder();
        for (RetrieverBuilder retriever : this.sources) {
            QueryBuilder query = retriever.topDocsQuery();
            if (query == null) continue;
            if (retriever.retrieverName() != null) {
                query.queryName(retriever.retrieverName());
            }
            boolQuery.should(query);
        }
        return boolQuery;
    }

    @Override
    public QueryBuilder explainQuery() {
        return new RankDocsQueryBuilder(this.rankDocs.get(), (QueryBuilder[])this.sources.stream().map(RetrieverBuilder::explainQuery).toArray(QueryBuilder[]::new), true);
    }

    @Override
    public void extractToSearchSourceBuilder(SearchSourceBuilder searchSourceBuilder, boolean compoundUsed) {
        RankDoc[] rankDocResults = this.rankDocs.get();
        RankDocsQueryBuilder rankQuery = this.hasAggregations(searchSourceBuilder) || this.isExplainRequest(searchSourceBuilder) || this.isProfileRequest(searchSourceBuilder) || this.shouldTrackTotalHits(searchSourceBuilder) ? (!this.isExplainRequest(searchSourceBuilder) ? new RankDocsQueryBuilder(rankDocResults, (QueryBuilder[])this.sources.stream().map(RetrieverBuilder::topDocsQuery).toArray(QueryBuilder[]::new), false) : new RankDocsQueryBuilder(rankDocResults, (QueryBuilder[])this.sources.stream().map(RetrieverBuilder::explainQuery).toArray(QueryBuilder[]::new), false)) : new RankDocsQueryBuilder(rankDocResults, null, false);
        searchSourceBuilder.query(rankQuery);
        if (this.sourceHasMinScore()) {
            searchSourceBuilder.minScore(this.minScore() == null ? Float.MIN_VALUE : this.minScore().floatValue());
        }
        if (searchSourceBuilder.size() + searchSourceBuilder.from() > rankDocResults.length) {
            searchSourceBuilder.size(Math.max(0, rankDocResults.length - searchSourceBuilder.from()));
        }
    }

    private boolean hasAggregations(SearchSourceBuilder searchSourceBuilder) {
        return searchSourceBuilder.aggregations() != null;
    }

    private boolean isExplainRequest(SearchSourceBuilder searchSourceBuilder) {
        return searchSourceBuilder.explain() != null && searchSourceBuilder.explain() != false;
    }

    private boolean isProfileRequest(SearchSourceBuilder searchSourceBuilder) {
        return searchSourceBuilder.profile();
    }

    private boolean shouldTrackTotalHits(SearchSourceBuilder searchSourceBuilder) {
        return searchSourceBuilder.trackTotalHitsUpTo() == null || searchSourceBuilder.trackTotalHitsUpTo() > this.rankDocs.get().length;
    }

    @Override
    protected boolean doEquals(Object o) {
        RankDocsRetrieverBuilder other = (RankDocsRetrieverBuilder)o;
        return this.rankWindowSize == other.rankWindowSize && Arrays.equals(this.rankDocs.get(), other.rankDocs.get()) && this.sources.equals(other.sources);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(super.hashCode(), this.rankWindowSize, Arrays.hashCode(this.rankDocs.get()), this.sources);
    }

    @Override
    protected void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        throw new UnsupportedOperationException("toXContent() is not supported for " + String.valueOf(this.getClass()));
    }
}

